/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.interloan.helper.InterLoanParamHelper;

public abstract class AbstractInterComLoanOrgDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String MIXORGNAME = "mixorgname";
    private static final String AMOUNT = "repayamount";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{MIXORGNAME, ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"AbstractInterComLoanOrgDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractInterComLoanOrgDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), paramMap);
        DataSet ds = InterCompanyLoansDataHelper.getInterCompanyLoanData((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDataSet, (boolean)this.isDebt(), (String)comloanRange);
        ds = ds.updateField(AMOUNT, "repayamount + rowoffset");
        ds = ds.groupBy(new String[]{this.groupField()}).sum(AMOUNT).finish();
        orgDataSet = orgDataSet.leftJoin(ds).on("rowid", this.groupField()).select(AbstractInterComLoanOrgDataPlugin.getSelectField().toArray(new String[0])).finish();
        ds = DecisionAnlsHelper.getSumDataSetByLevel(orgDataSet, Collections.singletonList(AMOUNT), MIXORGNAME);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        ds = CollectionUtils.isNotEmpty((Collection)secondOrgIds) ? ds.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds)) : ds.filter("rowid = id", Collections.singletonMap("id", orgId));
        ds = ds.filter("repayamount > 0");
        return ds;
    }

    private static List<String> getSelectField() {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.add("orgname");
        selectField.add(MIXORGNAME);
        selectField.add("rowid");
        selectField.add("orgid");
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        selectField.add(AMOUNT);
        return selectField;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), null);
        parameter.getCustomParams().put("comloanrange", comloanRange);
        parameter.setFormId(this.isDebt() ? "tda_borrowbalancerpt" : "tda_loanbalancerpt");
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return MIXORGNAME;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_borrowbalancerpt");
    }

    abstract boolean isDebt();

    abstract String groupField();

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        String comloanRange = (String)paramMap.get("comloanrange");
        param.getCustomParams().put("comloanrange", comloanRange);
        param.setFormId(this.isDebt() ? "tda_borrowbalancerpt" : "tda_loanbalancerpt");
    }
}

