/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.interloan.helper.InterLoanParamHelper;

public class BorrowInOutsideQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "repayamount";
    private static final String REGION_NUM = "regionnum";
    private static final String REGION = "region";
    protected static final String LEND_TYPE = "lendType";
    protected static final String DEBT = "org";
    protected static final String CREDITOR = "creditor";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{REGION_NUM, ResManager.loadKDString((String)"\u5883\u5185\u5916\u7f16\u7801", (String)"BorrowInOutSideQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{REGION, ResManager.loadKDString((String)"\u5883\u5185\u5916", (String)"BorrowInOutSideQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"BorrowInOutSideQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get(DEBT)).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), paramMap);
        DataSet ds = InterCompanyLoansDataHelper.getInterCompanyLoanData((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDs, (boolean)this.isDebit(), (String)comloanRange);
        ds = ds.filter("isequity=false").select("repayamount,rowoffset,coloffset,case when region=1 then region else 99 end as regionnum");
        ds = ds.updateField(AMOUNT, "repayamount + rowoffset + coloffset");
        ds = ds.groupBy(new String[]{REGION_NUM}).sum(AMOUNT).finish();
        ds = DecisionAnlsHelper.creatAbsentRow(ds, REGION_NUM, Arrays.asList("1", "99"), 0, () -> new Object[]{"0", 0.0});
        String regionStr = String.format("case when regionnum=1 then '%1$s' else '%2$s' end", AcctDisplayByBankTypeEnum.DOMESTIC.getName(), AcctDisplayByBankTypeEnum.OVERSEAS.getName());
        return ds.addField(regionStr, REGION);
    }

    protected boolean isDebit() {
        return true;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        parameter.getCustomParams().put(LEND_TYPE, this.isDebit() ? DEBT : CREDITOR);
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), null);
        parameter.getCustomParams().put("comloanrange", comloanRange);
        parameter.setCaption(this.isDebit() ? ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5883\u5185\u5916\u5206\u5e03\u8868-\u501f\u6b3e\u4eba", (String)"BorrowInOutSideQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5883\u5185\u5916\u5206\u5e03\u8868-\u503a\u6743\u4eba", (String)"BorrowInOutSideQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return REGION_NUM;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_interloanbycurrpt");
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put(LEND_TYPE, this.isDebit() ? DEBT : CREDITOR);
        String comloanRange = (String)paramMap.get("comloanrange");
        param.getCustomParams().put("comloanrange", comloanRange);
        param.setCaption(this.isDebit() ? ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5883\u5185\u5916\u5206\u5e03\u8868-\u501f\u6b3e\u4eba", (String)"BorrowInOutSideQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5883\u5185\u5916\u5206\u5e03\u8868-\u503a\u6743\u4eba", (String)"BorrowInOutSideQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
    }
}

