/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.InterCompanyLoansTermHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;
import kd.tmc.tda.report.interloan.helper.InterLoanParamHelper;

public class BorrowTermQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "repayamount";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"datarange", ResManager.loadKDString((String)"\u671f\u9650", (String)"BorrowTermQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"BorrowTermQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"order", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"BorrowTermQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), paramMap);
        DataSet ds = InterCompanyLoansTermHelper.getInterLoanTermData((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, null, (boolean)this.isDebit(), (String)comloanRange);
        ds = ds.filter("isequity=false").select("residueterm,repayamount,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond");
        ds = ds.updateField(AMOUNT, "repayamount + rowoffset + coloffset");
        ds = FinanceInterestBearLiaDisHelper.getDataByResidueterm(ds, paramMap, true);
        ds = ds.groupBy(new String[]{"order", "datarange"}).sum(AMOUNT).finish();
        return this.dealEmptyRow(ds, paramMap);
    }

    protected boolean isDebit() {
        return true;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        parameter.getCustomParams().put("isDebit", this.isDebit());
        String comloanRange = InterLoanParamHelper.getQingCustsupptype(this.getPageCache(), null);
        parameter.getCustomParams().put("comloanrange", comloanRange);
        if (this.isDebit()) {
            parameter.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5230\u671f\u671f\u9650\u5206\u5e03\u8868-\u6309\u501f\u6b3e\u4eba", (String)"BorrowTermQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5230\u671f\u671f\u9650\u5206\u5e03\u8868-\u6309\u503a\u6743\u4eba", (String)"BorrowTermQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put("isDebit", this.isDebit());
        String comloanRange = (String)paramMap.get("comloanrange");
        param.getCustomParams().put("comloanrange", comloanRange);
        if (this.isDebit()) {
            param.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5230\u671f\u671f\u9650\u5206\u5e03\u8868-\u6309\u501f\u6b3e\u4eba", (String)"BorrowTermQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5230\u671f\u671f\u9650\u5206\u5e03\u8868-\u6309\u503a\u6743\u4eba", (String)"BorrowTermQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "datarange";
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_bortermrpt");
    }

    private DataSet dealEmptyRow(DataSet ds, Map<String, Object> paramMap) {
        String[] dataRanges = (String[])paramMap.get("dataRangeArray");
        RowMeta rowMeta = ds.getRowMeta();
        for (int i = 0; i < dataRanges.length; ++i) {
            String dateStr = dataRanges[i];
            String filterConditions = String.format("datarange='%1$s'", dateStr);
            if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
            DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{i, dateStr, 0.0}));
            ds = ds.union(bizDs);
        }
        return ds.updateField("order", "case when order=14 then -1 else order end");
    }
}

