/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.interloan.qing.data.AbstractInterLoanDataPlugin;

public class InterLoanDebtByCurrencyDataPlugin
extends AbstractInterLoanDataPlugin {
    private static final String CURRENCY = "currency";

    @Override
    protected String lendType() {
        return "org";
    }

    @Override
    protected String businessField() {
        return CURRENCY;
    }

    @Override
    protected String getFormId() {
        return "tda_interloanbycurrpt";
    }

    @Override
    protected void setLinkShowParameter(ReportShowParameter showParameter) {
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u8d37\u5e01\u79cd\u5206\u5e03\u8868-\u501f\u6b3e\u4eba", (String)"InterLoanDebitByCurrencyDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
    }

    @Override
    protected DataSet beforeDataSet(DataSet dataSet) {
        Map<Object, DynamicObject> currencyMap = this.getCurrencyMap();
        ArrayList<Object> currencyIds = new ArrayList<Object>(currencyMap.keySet());
        return dataSet.updateField(CURRENCY, "case when currency in (" + DecisionCommonHelper.idListToString(currencyIds) + ") then " + CURRENCY + " else 99L end");
    }

    @Override
    protected DataSet afterDataSet(DataSet dataSet) {
        final Map<Object, DynamicObject> currencyMap = this.getCurrencyMap();
        String other = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InterLoanDebitByCurrencyDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        dataSet = dataSet.addField("'" + other + "'", "businessTypeName");
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Long currencyId = row.getLong(InterLoanDebtByCurrencyDataPlugin.CURRENCY);
                DynamicObject currency = (DynamicObject)currencyMap.get(currencyId);
                if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    String currencyName = currency.getString("name");
                    int currencyNameIndex = rowMeta.getFieldIndex("businessTypeName", false);
                    data[currencyNameIndex] = currencyName;
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private Map<Object, DynamicObject> getCurrencyMap() {
        return BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)String.join((CharSequence)",", "id", "number", "name"), (QFilter[])new QFilter("number", "in", Arrays.asList("CNY", "HKD", "USD")).toArray());
    }
}

