/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String BANKNAME = "bankname";
    private static final String BANKCATE = "bankcate";
    private static final String AMOUNT = "amount";
    private static final String ORGID = "orgid";
    private static final int TOP = 10;
    private static final String ROWID = "rowid";
    private static final String RATE = "rate";
    private static final String PROFIT = "profit";
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE_TYPE = "datetype";
    private static final String STATAMOUNT = "bankcate_statamount";
    private static final String STATPROFIT = "bankcate_statprofit";
    private static final String STATRATE = "bankcate_statrate";
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "0";
    private static final String OHTERFINANCE_ID = "2";
    private static final String BANK_SUMAMOUNT = "bankcate_sumamount";
    private static final String BANK_SUMPROFIT = "bankcate_sumprofit";
    private static final String BANK_SUMRATE = "bankcate_sumrate";
    private static final List<String> ORIGIN_AMT_FIELDS = Arrays.asList("amount", "profit", "rate");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL).select("company orgid,finorgtype,customtype,datetype,bankcatename bankname,bankcateid bankcate,avgprinciple amount,expectprofit profit,avgprinciple*expectrate rate");
        return ds.groupBy(new String[]{ORGID, DATE_TYPE, CUSTOM_TYPE, BANKNAME, BANKCATE, "finorgtype"}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish();
    }

    private DataSet handle(DataSet ds) {
        DataSet unionSet;
        DataSet[] splitDataSets = ds.splitByFilter(new String[]{"finorgtype = '0'", "finorgtype = '3'", "finorgtype = '1'"}, true);
        Pair<DataSet, DataSet> splitDsPair = DecisionAnlsHelper.splitTopBank(splitDataSets[0], AMOUNT, 10);
        DataSet topBankDs = this.groupAndSumAmt((DataSet)splitDsPair.getValue0()).orderBy(new String[]{"amount desc"});
        if (splitDsPair.getValue1() != null) {
            DataSet otherBankDs = this.groupAndSumAmt(((DataSet)splitDsPair.getValue1()).updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"InvestAmtBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID}));
            unionSet = topBankDs.union(otherBankDs);
        } else {
            unionSet = topBankDs;
        }
        DataSet financeDataSet = this.groupAndSumAmt(splitDataSets[1].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{"'" + FinOrgTypeEnum.FINCOMP.getName() + "'", FinOrgTypeEnum.FINCOMP.getValue()}));
        DataSet clearingHouseSet = this.groupAndSumAmt(splitDataSets[2].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{"'" + FinOrgTypeEnum.CLEARINGHOUSE.getName() + "'", FinOrgTypeEnum.CLEARINGHOUSE.getValue()}));
        DataSet otherFinOrgDataSet = this.groupAndSumAmt(splitDataSets[3].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u91d1\u878d\u673a\u6784'", (String)"InvestAmtBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERFINANCE_ID}));
        unionSet = unionSet.union(new DataSet[]{financeDataSet, clearingHouseSet, otherFinOrgDataSet});
        return unionSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        ds = this.handle(ds);
        Map paramMap = this.transQueryParam(queryParam);
        String customType = InvestReportDataHelper.getCustomType(paramMap);
        Integer dateType = (Integer)paramMap.get(DATE_TYPE);
        ds = ds.filter("customtype = '" + customType + "' and datetype = " + dateType);
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, new HashSet<String>(ORIGIN_AMT_FIELDS));
        DataSet copy = ds.copy();
        DataSet afterRowToColSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(ds, BANKCATE, ORGID, PREFIX, ORIGIN_AMT_FIELDS);
        Long orgView = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView);
        List<String> sumField = this.getSumField(afterRowToColSet);
        List<String> selectField = this.getSelectField(sumField);
        afterRowToColSet = this.groupby(afterRowToColSet, new String[]{ORGID}, sumField);
        DataSet orgJoinSet = orgDataSet.leftJoin(afterRowToColSet).on(ROWID, ORGID).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgIds));
        sumDataSet = sumDataSet.addFields(new String[]{this.getStatAmtCol(sumField, AMOUNT), this.getStatAmtCol(sumField, PROFIT), this.getStatAmtCol(sumField, RATE)}, new String[]{STATAMOUNT, STATPROFIT, STATRATE});
        sumDataSet = sumDataSet.filter("bankcate_statamount>0").orderBy(new String[]{"sortcode"});
        sumDataSet = sumDataSet.addFields(new String[]{this.getSumAmtCol(sumField, AMOUNT), this.getSumAmtCol(sumField, PROFIT), this.getSumAmtCol(sumField, RATE)}, new String[]{BANK_SUMAMOUNT, BANK_SUMPROFIT, BANK_SUMRATE});
        sumField.addAll(Arrays.asList(BANK_SUMAMOUNT, BANK_SUMPROFIT, BANK_SUMRATE, STATAMOUNT, STATPROFIT, STATRATE));
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = this.getCols(totalSet.copy(), copy);
        queryParam.getCustomParam().put("topBankMap", cols);
        DataSet resultDataSet = sumDataSet.union(totalSet);
        ArrayList<String> showColName = new ArrayList<String>(sumField);
        resultDataSet = this.setRateColData(showColName, resultDataSet);
        return resultDataSet;
    }

    private String getStatAmtCol(List<String> sumField, String suffix) {
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(suffix)).collect(Collectors.toSet());
        return CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : "0.0";
    }

    private String getSumAmtCol(List<String> sumField, String suffix) {
        Set<String> sumColSet = this.getBankCols(sumField, suffix);
        return CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : "0.0";
    }

    private DataSet groupby(DataSet groupDataSet, String[] groupStrs, List<String> sumFields) {
        GroupbyDataSet groupbyDataSet = groupDataSet.groupBy(groupStrs);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    private List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add(ORGID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }

    private List<AbstractReportColumn> getCols(DataSet totalSet, DataSet allData) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        ArrayList<AbstractReportColumn> datas = new ArrayList<AbstractReportColumn>();
        Set<String> bankCols = this.getBankCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()), AMOUNT);
        if (CollectionUtils.isNotEmpty(bankCols)) {
            Map<Long, String> bankMap = this.getBankColKeyAndNameMap(allData);
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            String otherBankCateColKey = this.getBankCateAmountColName(OHTERBANK_ID);
            bankCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherBankCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            Collections.sort(totalRowData, (o1, o2) -> ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1()));
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String bankCateIdStr = colKey.substring(PREFIX.length(), colKey.indexOf(AMOUNT));
                if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(bankCateIdStr)) continue;
                datas.add(this.getReportCol(bankMap.get(Long.valueOf(bankCateIdStr)), colKey, true));
            }
        }
        if (this.colExists(totalSet, OHTERBANK_ID)) {
            datas.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"InvestAmtBankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankCateAmountColName(OHTERBANK_ID), true));
        }
        datas.add(this.getReportCol(ResManager.loadKDString((String)"\u94f6\u884c\u5c0f\u8ba1", (String)"InvestAmtBankDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), BANK_SUMAMOUNT, true));
        if (this.colExists(totalSet, FinOrgTypeEnum.FINCOMP.getValue())) {
            datas.add(this.getReportCol(FinOrgTypeEnum.FINCOMP.getName(), this.getBankCateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()), true));
        }
        if (this.colExists(totalSet, FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            datas.add(this.getReportCol(FinOrgTypeEnum.CLEARINGHOUSE.getName(), this.getBankCateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()), true));
        }
        if (this.colExists(totalSet, OHTERFINANCE_ID)) {
            datas.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"InvestAmtBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankCateAmountColName(OHTERFINANCE_ID), true));
        }
        datas.add(this.getReportCol(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestAmtBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), STATAMOUNT, true));
        return datas;
    }

    private Map<Long, String> getBankColKeyAndNameMap(DataSet allData) {
        HashMap<Long, String> bankMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                bankMap.put(row.getLong(BANKCATE), row.getString(BANKNAME));
            }
        }
        return bankMap;
    }

    private boolean colExists(DataSet dataSet, String bankCateId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + bankCateId + AMOUNT, false) != -1;
    }

    private AbstractReportColumn getReportCol(String caption, String colKey, boolean isGroupCol) {
        ReportColumn result;
        if (isGroupCol) {
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(colKey + "Group");
            newColGroup.setCaption(new LocaleString(caption));
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("decimal");
            newCol.setScale(2);
            newCol.setZeroShow(true);
            newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"InvestAmtBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])));
            if ("bankcate_0amount".equals(colKey) || "bankcate_2amount".equals(colKey)) {
                newCol.setHyperlink(true);
            }
            if (colKey.endsWith(AMOUNT)) {
                colKey = colKey.substring(0, colKey.indexOf(AMOUNT));
            }
            ReportColumn profitCol = new ReportColumn();
            profitCol.setFieldKey(colKey + PROFIT);
            profitCol.setFieldType("decimal");
            profitCol.setScale(2);
            profitCol.setZeroShow(true);
            profitCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6536\u76ca", (String)"InvestAmtBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0])));
            ReportColumn newColRate = new ReportColumn();
            newColRate.setFieldKey(colKey + RATE);
            newColRate.setFieldType("text");
            ColumnStyle style = new ColumnStyle();
            style.setTextAlign("right");
            newColRate.setStyle(style);
            newColRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestAmtBankDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0])));
            List children = newColGroup.getChildren();
            children.add(newCol);
            children.add(profitCol);
            children.add(newColRate);
            result = newColGroup;
        } else {
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("text");
            newCol.setCaption(new LocaleString(caption));
            result = newCol;
        }
        return result;
    }

    private DataSet setRateColData(List<String> showColName, DataSet showData) {
        for (String col : showColName) {
            if (!col.endsWith(AMOUNT)) continue;
            String rateColName = col.substring(0, col.lastIndexOf(AMOUNT)) + RATE;
            showData = showData.updateField(rateColName, this.getCaseWhenSql(rateColName, col));
        }
        return showData;
    }

    private String getCaseWhenSql(String dividend, String divisor) {
        return String.format(" case when (%s is null or %s = 0) then 0.0 else %s/%s end ", divisor, divisor, dividend, divisor);
    }

    private Set<String> getBankCols(List<String> sumField, String suffix) {
        List<String> nonBankClos = Arrays.asList(this.getBankCateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()), this.getBankCateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()), this.getBankCateAmountColName(OHTERFINANCE_ID), this.getBankCateAmountColName("sum"), this.getBankCateAmountColName("stat"));
        return sumField.stream().filter(f -> f.endsWith(suffix) && !nonBankClos.contains(f)).collect(Collectors.toSet());
    }

    private String getBankCateAmountColName(String bankCateId) {
        return PREFIX + bankCateId + AMOUNT;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topBankMap");
        columns.addAll(cols);
        return columns;
    }

    private DataSet groupAndSumAmt(DataSet ds) {
        return ds.groupBy(new String[]{CUSTOM_TYPE, DATE_TYPE, ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish();
    }
}

