/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtOtherBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String PROFIT = "profit";
    private static final String RATE = "rate";
    private static final String COMPANY = "company";
    private static final String BANK_NAME = "bankname";
    private static final String DISPLAY_TYPE = "displayType";
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE_TYPE = "datetype";
    private static final int TOP = 10;

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        String orgViewNumber = orgView.getString("number");
        Long parentId = Long.valueOf(paramMap.get("parent_id").toString());
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(parentId), (boolean)true, (boolean)true);
        return this.getQueryDataSet(allOrgIds, orgView.getLong("id"), paramMap);
    }

    private DataSet getQueryDataSet(List<Long> allOrgIds, long orgViewId, Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet fundDataSet = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), allOrgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL).select("company,finorgtype,customtype,datetype,bankcatename,bankname,bankcateid bankcate,avgprinciple amount,expectprofit profit,avgprinciple*expectrate rate");
        return fundDataSet.groupBy(new String[]{COMPANY, "finorgtype", CUSTOM_TYPE, DATE_TYPE, "bankcatename", BANK_NAME, "bankcate"}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet fundDataSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String customType = InvestReportDataHelper.getCustomType(paramMap);
        Integer dateType = (Integer)paramMap.get(DATE_TYPE);
        fundDataSet = fundDataSet.filter("customtype = '" + customType + "' and datetype = " + dateType);
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        if ("finance".equals(displayType)) {
            List<String> finOrgTypeList = Arrays.asList(FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.CLEARINGHOUSE.getValue(), FinOrgTypeEnum.FINCOMP.getValue());
            fundDataSet = fundDataSet.filter("finorgtype not in finorgtypes", Collections.singletonMap("finorgtypes", finOrgTypeList)).select(new String[]{COMPANY, BANK_NAME, AMOUNT, PROFIT, RATE});
        } else {
            fundDataSet = fundDataSet.filter("finorgtype='0'").select(new String[]{COMPANY, "bankcatename bankname", AMOUNT, PROFIT, RATE});
            fundDataSet = this.getNoTopBankDs(fundDataSet);
        }
        String currentOrgId = (String)paramMap.get("current_org_id");
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(Long.valueOf(currentOrgId)), (boolean)true, (boolean)true);
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        if (EmptyUtil.isNoEmpty((String)currentOrgId) && currentOrgId.equals("" + orgId)) {
            subOrgIds.remove(orgId);
        }
        fundDataSet = fundDataSet.filter("company in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds));
        fundDataSet = fundDataSet.groupBy(new String[]{BANK_NAME}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish().addField("0", "sumlevel").orderBy(new String[]{"amount DESC"});
        DataSet sumDs = fundDataSet.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANK_NAME}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish().addField("2", "sumlevel");
        fundDataSet = fundDataSet.union(sumDs).updateField(RATE, this.getCaseWhenSql(RATE, AMOUNT));
        return this.removeAllZeroRow(fundDataSet, this.getAmountFields());
    }

    @Override
    protected Set<String> getAmountFields() {
        return Stream.of(AMOUNT, PROFIT).collect(Collectors.toSet());
    }

    private String getCaseWhenSql(String dividend, String divisor) {
        return String.format(" case when (%s is null or %s = 0) then 0 else %s/%s end ", divisor, divisor, dividend, divisor);
    }

    private DataSet getNoTopBankDs(DataSet ds) {
        DataSet topBankTempDs = ds.copy().filter("bankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"amount DESC"}).top(10);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        DataSet noTopBankDs = ds.filter(DecisionAnlsHelper.buildOtherFilter(topBanks, BANK_NAME));
        return noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).sum(PROFIT).sum(RATE).finish();
    }
}

