/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.InvestTermEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestBalanceDetailDataListPlugin
extends AbstractDetailDataPlugin {
    private static final String TERM_TYPE = "termType";

    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"InvestBalanceDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"investtype", ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u54c1\u79cd", (String)"InvestBalanceDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(this.investTypeEnumItemList())});
        field.add(new Object[]{"investbillno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"InvestBalanceDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"InvestBalanceDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784", (String)"InvestBalanceDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237", (String)"InvestBalanceDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"InvestBalanceDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"InvestBalanceDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"initialamount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvestBalanceDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"initialamountrpt", ResManager.loadKDString((String)"\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"InvestBalanceDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originalamount", ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestBalanceDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"InvestBalanceDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f", (String)"InvestBalanceDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"intdate", ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u671f", (String)"InvestBalanceDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"expiredate", ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f", (String)"InvestBalanceDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"term", ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650\u7c7b\u578b", (String)"InvestBalanceDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"residueterm", ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650\u7c7b\u578b", (String)"InvestBalanceDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"initialrate", ResManager.loadKDString((String)"\u5229\u7387\uff08%\uff09", (String)"InvestBalanceDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"frate", ResManager.loadKDString((String)"\u6700\u65b0\u5229\u7387\uff08%\uff09", (String)"InvestBalanceDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u62b5\u6d88\u6807\u8bc6", (String)"InvestBalanceDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = InvestDataHelper.getInvestBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        String props = "id, company orgname, company, investtype, billno investbillno, bankcatename, bankname, bankaccountnumber,currencyname, rate, originalamount, amount, initialamount, initialamountrpt, bizdate, intdate, expiredate,term, residueterm, initialrate, frate, isoffset,amount isoffset_amount, initialamountrpt isoffset_initialamountrpt";
        ds = ds.select(props);
        String termType = (String)paramMap.get(TERM_TYPE);
        if (EmptyUtil.isNoEmpty((String)termType)) {
            ds = ds.filter("residueterm != '-1d'");
        }
        ds = this.parseTerm(ds);
        return ds.updateFields(new String[]{"amount", "initialamountrpt"}, new String[]{"case when isoffset='1' then 0.0 else amount end", "case when isoffset='1' then 0.0 else initialamountrpt end"});
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("amount", "initialamountrpt", "isoffset_amount", "isoffset_initialamountrpt");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("investbillno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String investType = rowData.getString("investtype");
            String linkEntity = CashTypeEnum.FINANCE.getValue().equals(investType) ? "cim_finsubscribe" : (CashTypeEnum.NOTICE.getValue().equals(investType) ? "cim_noticedeposit" : (CashTypeEnum.FIX.getValue().equals(investType) || CashTypeEnum.STRUCT.getValue().equals(investType) || CashTypeEnum.HUGE.getValue().equals(investType) ? "cim_deposit" : "cim_finsubscribe"));
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected List<String> getOrderByList() {
        ArrayList<String> orderList = new ArrayList<String>(2);
        orderList.add("investtype");
        orderList.add("investbillno");
        return orderList;
    }

    private String[] investTypeEnumItemList() {
        InvestTypeEnum[] entityEnums = InvestTypeEnum.values();
        String[] array = new String[entityEnums.length * 2];
        int i = 0;
        for (InvestTypeEnum investTypeEnum : entityEnums) {
            array[i] = investTypeEnum.getValue();
            array[i + 1] = investTypeEnum.getName();
            i += 2;
        }
        return array;
    }

    private DataSet parseTerm(DataSet ds) {
        final RowMeta rowMetas = ds.getRowMeta();
        return ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(10);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("term".equals(fieldName) || "residueterm".equals(fieldName)) {
                        String term = row.getString(fieldName);
                        InvestTermEnum termEnum = InvestTermEnum.getInvestTermEnum((String)term);
                        if (termEnum != null) {
                            rowInfo.add(termEnum.getText());
                            continue;
                        }
                        rowInfo.add("");
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
    }
}

