/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestBalanceOtherBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String AMOUNTRATE = "amountrate";
    private static final String COMPANY = "company";
    private static final String BANK_NAME = "bankname";
    private static final int TOP_NUMBER = 10;
    private static final String DISPLAY_TYPE = "displayType";

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        String orgViewNumber = orgView.getString("number");
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(orgId), (boolean)true, (boolean)true);
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        param.getCustomParam().put(DISPLAY_TYPE, displayType);
        return this.getQueryDataSet(allOrgIds, queryDate, paramMap);
    }

    private DataSet getQueryDataSet(List<Long> orgIds, Date queryDate, Map<String, Object> paramMap) {
        DataSet fundDataSet;
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        List<String> finorgtypeList = Collections.singletonList(FinOrgTypeEnum.BANK.getValue());
        if ("finance".equals(displayType)) {
            finorgtypeList = Arrays.asList(FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.CLEARINGHOUSE.getValue(), FinOrgTypeEnum.FINCOMP.getValue());
            fundDataSet = InvestDataHelper.getInvestBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId).filter("finorgtype not in finorgtypes", Collections.singletonMap("finorgtypes", finorgtypeList)).select(new String[]{COMPANY, AMOUNT, "frate", BANK_NAME, "finorgtype"});
        } else {
            fundDataSet = InvestDataHelper.getInvestBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId).filter("finorgtype in finorgtypes", Collections.singletonMap("finorgtypes", finorgtypeList)).select(new String[]{COMPANY, AMOUNT, "frate", "bankcatename bankname", "finorgtype"});
        }
        fundDataSet = fundDataSet.addField("amount * frate", AMOUNTRATE);
        fundDataSet = fundDataSet.groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        if ("bank".equals(displayType)) {
            fundDataSet = this.handleDataSet(fundDataSet);
        }
        String currentOrgId = (String)paramMap.get("current_org_id");
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(Long.valueOf(currentOrgId)), (boolean)true, (boolean)true);
        if (EmptyUtil.isNoEmpty((String)currentOrgId) && currentOrgId.equals("" + orgId)) {
            subOrgIds.remove(orgId);
        }
        if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds.add(orgId);
        }
        fundDataSet = fundDataSet.filter("company in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("amount >0");
        fundDataSet = fundDataSet.groupBy(new String[]{BANK_NAME}).sum(AMOUNT).sum(AMOUNTRATE).finish().orderBy(new String[]{"amount DESC"});
        fundDataSet = fundDataSet.addField("0", "sumlevel");
        DataSet sumDs = fundDataSet.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANK_NAME}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        sumDs = sumDs.addField("1", "sumlevel");
        fundDataSet = fundDataSet.union(sumDs.select(fundDataSet.getRowMeta().getFieldNames()));
        return fundDataSet.updateField(AMOUNTRATE, this.getCaseWhenSql(AMOUNTRATE, AMOUNT));
    }

    private DataSet handleDataSet(DataSet ds) {
        DataSet topBankTempDs = ds.copy().filter("bankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).sum(AMOUNTRATE).finish().orderBy(new String[]{"amount DESC"}).top(10);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        DataSet noTopBankDs = ds.filter(DecisionAnlsHelper.buildOtherFilter(topBanks, BANK_NAME));
        return noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).sum(AMOUNTRATE).finish();
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String displayType = (String)this.getQueryParam().getCustomParam().get(DISPLAY_TYPE);
        for (AbstractReportColumn column : columns) {
            if (!"finance".equals(displayType) || !((ReportColumn)column).getFieldKey().equals(BANK_NAME)) continue;
            column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784\u7c7b\u578b", (String)"InvestBalanceOtherBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        }
        return columns;
    }

    private String getCaseWhenSql(String dividend, String divisor) {
        return String.format(" case when (%s is null or %s = 0) then 0 else (%s) end ", divisor, divisor, dividend + "/" + divisor);
    }
}

