/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestBankBalanceDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String BANKNAME = "bankname";
    private static final String BANKCATE = "bankcate";
    private static final String AMOUNT = "amount";
    private static final String AMOUNTRATE = "amountrate";
    private static final String ISOFFSET = "isoffset";
    private static final String ORGID = "orgid";
    private static final int TOP = 10;
    private static final String ROWID = "rowid";
    private static final String RATE = "rate";
    private static final String STAT = "bankcate_stat";
    private static final String STATRATE = "bankcate_statrate";
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "0";
    private static final String OHTERFINANCE_ID = "2";
    private static final String BANK_SUM = "bankcate_sum";
    private static final String BANK_SUM_RATE = "bankcate_sumrate";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        DataSet domesticUnionSet;
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        String selectStr = "company orgid,finorgtype,bankcatename bankname,bankcateid bankcate,amount,frate,isoffset";
        ds = ds.select(selectStr).addField("amount * frate", AMOUNTRATE);
        DataSet[] splitDataSets = ds.splitByFilter(new String[]{"finorgtype = '0'", "finorgtype = '3'", "finorgtype = '1'"}, true);
        DataSet bankDataSte = splitDataSets[0];
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitTopBank(bankDataSte, AMOUNT, 10);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, ISOFFSET}).sum(AMOUNT).sum(AMOUNTRATE).finish().orderBy(new String[]{"amount desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet otherDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"InvestBankAmountQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, ISOFFSET}).sum(AMOUNT).sum(AMOUNTRATE).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(otherDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        DataSet financeDataSet = splitDataSets[1].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{"'" + FinOrgTypeEnum.FINCOMP.getName() + "'", FinOrgTypeEnum.FINCOMP.getValue()}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, ISOFFSET}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        DataSet clearingHouseSet = splitDataSets[2].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{"'" + FinOrgTypeEnum.CLEARINGHOUSE.getName() + "'", FinOrgTypeEnum.CLEARINGHOUSE.getValue()}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, ISOFFSET}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        DataSet otherFinorgDataSet = splitDataSets[3].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u91d1\u878d\u673a\u6784'", (String)"InvestBankAmountQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERFINANCE_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, ISOFFSET}).sum(AMOUNT).sum(AMOUNTRATE).finish();
        return domesticUnionSet.union(new DataSet[]{financeDataSet, clearingHouseSet, otherFinorgDataSet});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, new HashSet<String>(Arrays.asList(AMOUNT, AMOUNTRATE)));
        DataSet copy = ds.copy();
        DataSet afterChangeRowToColSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(ds, BANKCATE, "orgid,isoffset", PREFIX, Arrays.asList(AMOUNT, AMOUNTRATE));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = this.getSumField(afterChangeRowToColSet);
        List<String> selectField = this.getSelectField(sumField);
        selectField.add("sortcode");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        long parentOrgIdStr = ((DynamicObject)parentOrgs.get(0)).getLong("id");
        ArrayList allOrgIds = new ArrayList((List)paramMap.get("allorgids"));
        allOrgIds.remove(parentOrgIdStr);
        DataSet offsetdataSet = afterChangeRowToColSet.copy().filter("isoffset = '1'");
        if (CollectionUtils.isNotEmpty(allOrgIds)) {
            offsetdataSet = offsetdataSet.where("orgid in (" + TmcBusinessBaseHelper.idListToString(allOrgIds) + ")");
        }
        offsetdataSet = offsetdataSet.updateField(ORGID, "0L");
        offsetdataSet = this.groupby(offsetdataSet, new String[]{ORGID}, sumField);
        DataSet offsetOrgJoinSet = offsetdataSet.leftJoin(orgDateSet).on(ORGID, ROWID).select(selectField.toArray(new String[0])).finish();
        DataSet offsetTotalSet = this.getUpdataOffsetDataBySumFields(offsetOrgJoinSet, sumField);
        afterChangeRowToColSet = this.groupby(afterChangeRowToColSet, new String[]{ORGID}, sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(afterChangeRowToColSet).on(ROWID, ORGID).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgids));
        sumDataSet = sumDataSet.union(offsetTotalSet.select(sumDataSet.getRowMeta().getFieldNames()));
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(AMOUNT)).collect(Collectors.toSet());
        Set sumRateColSet = sumField.stream().filter(f -> f.endsWith(AMOUNTRATE)).collect(Collectors.toSet());
        sumDataSet = sumDataSet.addFields(new String[]{CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : OHTERBANK_ID, CollectionUtils.isNotEmpty(sumRateColSet) ? String.join((CharSequence)"+", sumRateColSet) : OHTERBANK_ID}, new String[]{STAT, STATRATE});
        DataSet[] splitDataStes = sumDataSet.splitByFilter(new String[]{String.format("orgid != %s and bankcate_stat > 0", "0L"), "bankcate_stat != null and bankcate_stat < 0"}, false);
        sumDataSet = splitDataStes[0].orderBy(new String[]{"sortcode"}).union(splitDataStes[1]);
        Set<String> bankCols = this.getBankCols(sumField, AMOUNT);
        Set<String> bankRateCols = this.getBankCols(sumField, AMOUNTRATE);
        sumDataSet = sumDataSet.addFields(new String[]{CollectionUtils.isNotEmpty(bankCols) ? String.join((CharSequence)"+", bankCols) : OHTERBANK_ID, CollectionUtils.isNotEmpty(bankRateCols) ? String.join((CharSequence)"+", bankRateCols) : OHTERBANK_ID}, new String[]{BANK_SUM, BANK_SUM_RATE});
        sumField.addAll(Arrays.asList(BANK_SUM, BANK_SUM_RATE, STAT, STATRATE));
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = this.getCols(totalSet.copy(), copy);
        queryParam.getCustomParam().put("topBankMap", cols);
        DataSet resultDataSet = sumDataSet.union(totalSet);
        resultDataSet = resultDataSet.updateField("sumlevel", "case when bankcate_stat != null and bankcate_stat < 0 then 3 else sumlevel end");
        ArrayList<String> showColName = new ArrayList<String>(sumField);
        resultDataSet = this.setRateColData(showColName, resultDataSet);
        return resultDataSet;
    }

    private DataSet getUpdataOffsetDataBySumFields(DataSet offsetOrgJoinSet, List<String> sumField) {
        DataSet offsetTotalSet = offsetOrgJoinSet.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode"}, new String[]{ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID, "'0'"});
        if (sumField.contains("bankcate_1amount")) {
            offsetTotalSet = offsetTotalSet.updateFields(new String[]{"bankcate_1amount", "bankcate_1amountrate"}, new String[]{"bankcate_1amount * (-1)", "bankcate_1amountrate * (-1)"});
        }
        if (sumField.contains("bankcate_3amount")) {
            offsetTotalSet = offsetTotalSet.updateFields(new String[]{"bankcate_3amount", "bankcate_3amountrate"}, new String[]{"bankcate_3amount * (-1)", "bankcate_3amountrate * (-1)"});
        }
        return offsetTotalSet;
    }

    private DataSet groupby(DataSet groupDataSet, String[] groupStrs, List<String> sumFields) {
        GroupbyDataSet groupbyDataSet = groupDataSet.groupBy(groupStrs);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    private List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add(ORGID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    private List<AbstractReportColumn> getCols(DataSet totalSet, DataSet allData) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        Map<Long, String> bankMap = this.getBankColKayAndNameMap(allData);
        Set<String> bankCols = this.getBankCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()), AMOUNT);
        ArrayList<AbstractReportColumn> datas = new ArrayList<AbstractReportColumn>();
        String otherBankCateColKey = this.getBankcateAmountColName(OHTERBANK_ID);
        if (CollectionUtils.isNotEmpty(bankCols)) {
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            bankCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherBankCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            Collections.sort(totalRowData, (o1, o2) -> ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1()));
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String substring = colKey.substring(PREFIX.length(), colKey.indexOf(AMOUNT));
                Long bankCateId = Long.valueOf(substring);
                if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(substring)) continue;
                datas.add(this.getReportCol(bankMap.get(bankCateId), colKey, true));
            }
        }
        if (this.colExists(totalSet, OHTERBANK_ID)) {
            datas.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"CashBankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankcateAmountColName(OHTERBANK_ID), true));
        }
        datas.add(this.getReportCol(ResManager.loadKDString((String)"\u94f6\u884c\u5c0f\u8ba1", (String)"InvestBankBalanceDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), BANK_SUM, true));
        if (this.colExists(totalSet, FinOrgTypeEnum.FINCOMP.getValue())) {
            datas.add(this.getReportCol(FinOrgTypeEnum.FINCOMP.getName(), this.getBankcateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()), true));
        }
        if (this.colExists(totalSet, FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            datas.add(this.getReportCol(FinOrgTypeEnum.CLEARINGHOUSE.getName(), this.getBankcateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()), true));
        }
        if (this.colExists(totalSet, OHTERFINANCE_ID)) {
            datas.add(this.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"InvestBankBalanceDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), this.getBankcateAmountColName(OHTERFINANCE_ID), true));
        }
        return datas;
    }

    private Map<Long, String> getBankColKayAndNameMap(DataSet allData) {
        HashMap<Long, String> bankMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                bankMap.put(row.getLong(BANKCATE), row.getString(BANKNAME));
            }
        }
        return bankMap;
    }

    private boolean colExists(DataSet dataSet, String bankCateId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + bankCateId + AMOUNT, false) != -1;
    }

    private AbstractReportColumn getReportCol(String catpion, String colKey, boolean isGroupCol) {
        ReportColumn result;
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        if (isGroupCol) {
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(colKey + "Group");
            newColGroup.setCaption(new LocaleString(catpion));
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("text");
            newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"CashBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])));
            newCol.setStyle(columnStyle);
            if ("bankcate_0amount".equals(colKey) || "bankcate_2amount".equals(colKey)) {
                newCol.setHyperlink(true);
            }
            ReportColumn newColRate = new ReportColumn();
            newColRate.setFieldKey(colKey + RATE);
            newColRate.setFieldType("text");
            newColRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestByBalanceDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
            List children = newColGroup.getChildren();
            children.add(newCol);
            children.add(newColRate);
            newColRate.setStyle(columnStyle);
            result = newColGroup;
        } else {
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(colKey);
            newCol.setFieldType("text");
            newCol.setCaption(new LocaleString(catpion));
            newCol.setStyle(columnStyle);
            result = newCol;
        }
        return result;
    }

    private DataSet setRateColData(List<String> showColName, DataSet showData) {
        for (String col : showColName) {
            if (col.endsWith(RATE)) continue;
            showData = showData.addField(this.getCaseWhenSql(col + RATE, col), col + RATE);
        }
        return showData;
    }

    private String getCaseWhenSql(String dividend, String divisor) {
        return String.format(" case when (%s is null or %s = 0) then 0 else (%s) end ", divisor, divisor, dividend + "/" + divisor);
    }

    private Set<String> getBankCols(List<String> sumField, String suffix) {
        return sumField.stream().filter(f -> f.endsWith(suffix) && !this.getBankcateAmountColName(FinOrgTypeEnum.FINCOMP.getValue()).equals(f) && !this.getBankcateAmountColName(FinOrgTypeEnum.CLEARINGHOUSE.getValue()).equals(f) && !this.getBankcateAmountColName(OHTERFINANCE_ID).equals(f)).collect(Collectors.toSet());
    }

    private String getBankcateAmountColName(String bankCateId) {
        return PREFIX + bankCateId + AMOUNT;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topBankMap");
        columns.addAll(cols);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        ReportColumnGroup newColGroup = new ReportColumnGroup();
        newColGroup.setFieldKey("sumGroup");
        newColGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestBankBalanceDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(STAT);
        newCol.setFieldType("text");
        newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"CashBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])));
        newCol.setStyle(columnStyle);
        ReportColumn newColRate = new ReportColumn();
        newColRate.setFieldKey(STATRATE);
        newColRate.setFieldType("text");
        newColRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestByBalanceDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
        List children = newColGroup.getChildren();
        newColRate.setStyle(columnStyle);
        children.add(newCol);
        children.add(newColRate);
        columns.add((AbstractReportColumn)newColGroup);
        return columns;
    }
}

