/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestByBalanceDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(InvestByBalanceDataListPlugin.class);
    private static final String ORGID = "orgid";
    private static final String BALANCE = "balance";
    private static final String TEMPBALANCE = "tempbalance";
    private static final String INVESTTYPE = "investtype";
    private static final String ISOFFSET = "isoffset";
    private static final String BALANCE_SUFFIX = "bl";
    private static final String TEMPBALANCE_SUFFIX = "tb";
    private static final String INVESTTYPE_PREFIX = "it_";
    private static final String TOTAL_YIELD = "it_total_tb";
    private static final String TOTAL_BALANCE = "it_total_bl";
    private static final String TOTAL = "total";
    private List<String> COLUMNS = new ArrayList<String>(16);

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet investBalanceDataSet = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId).select(new String[]{"company as orgid", "amount as balance", "amount * frate as tempbalance", INVESTTYPE, ISOFFSET});
        DataSet queryResultSet = investBalanceDataSet.groupBy(new String[]{ORGID, INVESTTYPE, ISOFFSET}).sum(BALANCE).sum(TEMPBALANCE).finish();
        return queryResultSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        long start = System.currentTimeMillis();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet processDataSet = this.processDataSet(paramMap, orgViewId, ds);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        DataSet filterDataSet = processDataSet;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            subOrgIds.add(0L);
            filterDataSet = filterDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds)).filter("it_total_bl> 0 or orgid = 0L");
        }
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(filterDataSet, this.getFieldNames(filterDataSet), "mixorgname");
        totalDataSet = totalDataSet.updateField(ORGID, orgId + "L");
        DataSet resultDataSet = filterDataSet.union(totalDataSet);
        resultDataSet = this.updateField(resultDataSet);
        logger.info("\u6295\u8d44\u7406\u8d22-\u4f59\u989d" + orgViewId + " \u5904\u7406\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        this.COLUMNS = this.getFieldNames(resultDataSet);
        return resultDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<ValueMapItem> propertyItems = DecisionAnlsHelper.getEnumItemsByProperty("cim_investvarieties", INVESTTYPE);
        Map<String, ValueMapItem> valueItems = propertyItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, valueItem -> valueItem));
        LinkedHashMap<String, ReportColumnGroup> groupMap = new LinkedHashMap<String, ReportColumnGroup>();
        for (String fieldName : this.COLUMNS) {
            String[] fieldNameSplit = fieldName.split("_");
            String investType = fieldNameSplit[1];
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)groupMap.get(investType);
            if (reportColumnGroup == null) {
                LocaleString caption;
                reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setFieldKey(investType);
                if (investType.equals(TOTAL)) {
                    String totalName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestByBalanceDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
                    caption = new LocaleString(totalName);
                } else {
                    if (valueItems.get(investType) == null) continue;
                    caption = valueItems.get(investType).getName();
                }
                reportColumnGroup.setCaption(caption);
                groupMap.put(investType, reportColumnGroup);
            }
            String columnCaption = "";
            columnCaption = fieldName.endsWith(TEMPBALANCE_SUFFIX) ? (fieldName.contains(TOTAL) ? ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestByBalanceDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestByBalanceDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])) : ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestByBalanceDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
            ReportColumn column = this.createColumn(fieldName, columnCaption);
            reportColumnGroup.getChildren().add(column);
        }
        groupMap.forEach((k, v) -> columns.add((AbstractReportColumn)v));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("text");
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    @Override
    protected Set<String> getAmountFields() {
        return this.COLUMNS.stream().filter(fieldName -> fieldName.endsWith(BALANCE_SUFFIX)).collect(Collectors.toSet());
    }

    private DataSet processDataSet(Map<String, Object> paramMap, Long orgViewId, DataSet dataSet) {
        DataSet[] splits = dataSet.splitByFilter(new String[]{"isoffset IN ('0','1')", "isoffset = '1'"}, false);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(BALANCE, BALANCE_SUFFIX);
        map.put(TEMPBALANCE, TEMPBALANCE_SUFFIX);
        DataSet allDataSet = splits[0].groupBy(new String[]{ORGID, INVESTTYPE}).sum(BALANCE).sum(TEMPBALANCE).finish();
        allDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(allDataSet, INVESTTYPE, ORGID, INVESTTYPE_PREFIX, map);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> fieldNames = this.getFieldNames(allDataSet);
        DataSet leftJoinDs = orgDateSet.leftJoin(allDataSet).on("rowid", ORGID).select(new String[]{ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, fieldNames.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = this.getSumDataSetByLevel(leftJoinDs, fieldNames, "orgid,mixorgname,sortcode");
        DataSet offsetRow = this.getOffsetRow(paramMap, splits[1], fieldNames);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        DataSet resultSet = sumDataSet.union(offsetRow.select(sumDataSet.getRowMeta().getFieldNames()));
        List fields = Arrays.stream(resultSet.getRowMeta().getFieldNames()).collect(Collectors.toList());
        List balanceFields = fields.stream().filter(fieldName -> fieldName.endsWith(BALANCE_SUFFIX)).collect(Collectors.toList());
        List tempBalanceFields = fields.stream().filter(fieldName -> fieldName.endsWith(TEMPBALANCE_SUFFIX)).collect(Collectors.toList());
        resultSet = resultSet.addFields(new String[]{String.join((CharSequence)"+", balanceFields), String.join((CharSequence)"+", tempBalanceFields)}, new String[]{TOTAL_BALANCE, TOTAL_YIELD});
        return resultSet;
    }

    private DataSet getOffsetRow(Map<String, Object> paramMap, DataSet dataSet, List<String> fieldNames) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(BALANCE, BALANCE_SUFFIX);
        map.put(TEMPBALANCE, TEMPBALANCE_SUFFIX);
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allOrgIds = (List)paramMap.get("allorgids");
        ArrayList subOrgIds = new ArrayList(allOrgIds);
        subOrgIds.remove(orgId);
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            dataSet = dataSet.where("orgid in (" + TmcBusinessBaseHelper.idListToString(subOrgIds) + ")");
        }
        DataSet offsetRow = dataSet.groupBy(new String[]{INVESTTYPE}).sum(BALANCE).sum(TEMPBALANCE).finish();
        offsetRow = offsetRow.updateFields(new String[]{BALANCE, TEMPBALANCE}, new String[]{"-balance", "-tempbalance"});
        offsetRow = offsetRow.addFields(new String[]{"0L", "0"}, new String[]{ORGID, "sumlevel"});
        offsetRow = DecisionAnlsHelper.ChangeRowToMultiColDataSet(offsetRow, INVESTTYPE, ORGID, INVESTTYPE_PREFIX, map);
        String mergeName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"InvestByBalanceDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetRow = offsetRow.addFields(new String[]{"0L", "0L", "'0'", "'0'", "0", "0", "'" + mergeName + "'"}, new String[]{"rowid", "pid", "isgroupnode", "sortcode", "level", "sumlevel", "mixorgname"});
        List offsetRowFields = Arrays.stream(offsetRow.getRowMeta().getFieldNames()).collect(Collectors.toList());
        ArrayList<String> absentField = new ArrayList<String>(fieldNames.size());
        ArrayList<String> absentValue = new ArrayList<String>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (offsetRowFields.contains(fieldNames.get(i))) continue;
            absentField.add(fieldNames.get(i));
            absentValue.add("0.0");
        }
        offsetRow = offsetRow.addFields(absentValue.toArray(new String[0]), absentField.toArray(new String[0]));
        return offsetRow;
    }

    private DataSet updateField(DataSet dataSet) {
        final RowMeta rowMeta = dataSet.getRowMeta();
        List<String> fieldNames = this.getFieldNames(dataSet);
        final List finalFieldNames = fieldNames.stream().sorted().collect(Collectors.toList());
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                for (int i = 0; i < finalFieldNames.size(); i += 2) {
                    String balanceName = (String)finalFieldNames.get(i);
                    String tempBalanceName = (String)finalFieldNames.get(i + 1);
                    BigDecimal balance = row.getBigDecimal(balanceName) == null ? BigDecimal.ZERO : row.getBigDecimal(balanceName);
                    BigDecimal tempBalance = row.getBigDecimal(tempBalanceName) == null ? BigDecimal.ZERO : row.getBigDecimal(tempBalanceName);
                    int tempBalanceIndex = rowMeta.getFieldIndex(tempBalanceName, false);
                    data[tempBalanceIndex] = balance.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : tempBalance.divide(balance, 4, 4);
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    private List<String> getFieldNames(DataSet dataSet) {
        return Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(INVESTTYPE_PREFIX)).collect(Collectors.toList());
    }
}

