/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestRateTrendDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ROWID = "rowid";
    private static final String AMOUNT = "amount";
    private static final String PROFIT = "profit";
    private static final String AMOUNT_FIELD_NAMES = "amountFieldNames";
    private static final String RATE_FIELD_NAMES = "rateFieldNames";
    private List<String> sumFields;

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDs = InvestDataHelper.getInvestDataSet((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        allDs = allDs.select("company orgid,customtype,datetype,avgprinciple amount,expectprofit profit,avgprinciple*expectrate rateamount");
        return allDs.groupBy(new String[]{"orgid", "customtype", "datetype"}).sum(AMOUNT, "stat_amount").sum(PROFIT, "stat_profit").sum("rateamount", "stat_rateamount").finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        ds = ds.filter("customtype='" + InvestReportDataHelper.getCustomType(paramMap) + "'");
        ds = this.addAmountFields(ds, paramMap);
        List<String> sumFields = this.getSumField(ds);
        GroupbyDataSet groupDs = ds.groupBy(new String[]{"orgid"});
        for (String fieldName : sumFields) {
            groupDs.sum(fieldName);
        }
        ds = groupDs.finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet orgJoinSet = orgDateSet.leftJoin(ds).on(ROWID, "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        ds = this.getSumDataSetByLevel(orgJoinSet, sumFields, "sortcode,orgid,mixorgname");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        ds = EmptyUtil.isEmpty((Collection)subOrgIds) ? ds.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat_amount>0") : ds.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat_amount>0");
        ds = ds.orderBy(new String[]{"sortcode"}).addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(ds, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        DataSet resultDs = ds.union(totalSet);
        return this.addProfitFields(resultDs, paramMap, param);
    }

    private DataSet addAmountFields(DataSet ds, Map<String, Object> paramMap) {
        int[] dateTypes = this.getDateTypes(paramMap);
        int size = 3 * dateTypes.length;
        String[] amountFieldNames = new String[size];
        String[] amountFieldValues = new String[size];
        int i = 0;
        for (int dateType : dateTypes) {
            amountFieldNames[i] = dateType + "_amount";
            amountFieldNames[i + 1] = dateType + "_profit";
            amountFieldNames[i + 2] = dateType + "_rateamount";
            amountFieldValues[i] = "case when datetype=" + dateType + " then stat_amount else 0.0 end";
            amountFieldValues[i + 1] = "case when datetype=" + dateType + " then stat_profit else 0.0 end";
            amountFieldValues[i + 2] = "case when datetype=" + dateType + " then stat_rateamount else 0.0 end";
            i += 3;
        }
        paramMap.put(AMOUNT_FIELD_NAMES, amountFieldNames);
        return ds.addFields(amountFieldValues, amountFieldNames);
    }

    private DataSet addProfitFields(DataSet ds, Map<String, Object> paramMap, ReportQueryParam param) {
        Object[] amountFieldNames = (String[])paramMap.get(AMOUNT_FIELD_NAMES);
        if (EmptyUtil.isNoEmpty((Object[])amountFieldNames)) {
            int size = amountFieldNames.length / 3;
            String[] rateFieldNames = new String[size];
            String[] rateFieldValues = new String[size];
            for (int i = 0; i < size; ++i) {
                Object amountName = amountFieldNames[3 * i];
                Object rateAmountName = amountFieldNames[3 * i + 2];
                rateFieldNames[i] = ((String)amountName).substring(0, ((String)amountName).lastIndexOf(95)) + "_rate";
                String s = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round(%2$s/%1$s, 2) end", amountName, rateAmountName);
                rateFieldValues[i] = "concat(" + s + ", ' %')";
            }
            param.getCustomParam().put(RATE_FIELD_NAMES, rateFieldNames);
            return ds.addFields(rateFieldValues, rateFieldNames);
        }
        return ds;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        Object[] rateFieldNames = (String[])this.getQueryParam().getCustomParam().get(RATE_FIELD_NAMES);
        if (EmptyUtil.isEmpty((Object[])rateFieldNames)) {
            return columns;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String[] dateTypeArray = FinanceCostDateHelper.parseNewDateType((Date)queryDate);
        for (Object rateFieldName : rateFieldNames) {
            String[] splits = ((String)rateFieldName).split("_");
            String dateStr = splits[0];
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(dateStr);
            if (dateStr != null) {
                group.setCaption(new LocaleString(dateTypeArray[Integer.parseInt(dateStr)]));
            } else {
                group.setCaption(new LocaleString(""));
            }
            InvestReportDataHelper.addChildren(group, dateStr);
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(64);
        if (EmptyUtil.isNoEmpty(this.sumFields)) {
            fields.addAll(this.sumFields);
        }
        return fields;
    }

    private List<String> getSumField(DataSet ds) {
        if (EmptyUtil.isNoEmpty(this.sumFields)) {
            return this.sumFields;
        }
        this.sumFields = new ArrayList<String>(64);
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AMOUNT) && !fieldName.endsWith(PROFIT)) continue;
            this.sumFields.add(fieldName);
        }
        return this.sumFields;
    }

    private int[] getDateTypes(Map<String, Object> paramMap) {
        String customType = InvestReportDataHelper.getCustomType(paramMap);
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)customType);
        int start = dateRangeEnum.getStart();
        int end = dateRangeEnum.getEnd();
        int length = end - start + 1;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = start++;
        }
        return array;
    }
}

