/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InvestAmtBankFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String DISPLAY_TYPE = "displayType";
    private static final String PREFIX = "bankcate_";
    private static final String FILTER_COMPANY = "filter_company";
    private static final String DATE_TYPE = "datetype";
    private static final String TOP_BANKCATE = "topbankcate";

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPk, rowData, queryParam);
        for (DynamicObject row : rowData) {
            for (String colName : this.getRateColName(rowData)) {
                InvestAmtBankFormPlugin.setCellShow(colName, row);
            }
        }
    }

    private static void setCellShow(String colName, DynamicObject row) {
        BigDecimal rateBigDecimal = StringUtils.isEmpty((String)row.getString(colName)) ? BigDecimal.ZERO : row.getBigDecimal(colName);
        String showStr = rateBigDecimal.setScale(2, RoundingMode.HALF_UP).toString();
        if (colName.endsWith("rate")) {
            showStr = showStr + " %";
        }
        row.set(colName, (Object)showStr);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String[] fields = this.parseClickField(customParams);
        queryParam.getFilter().addFilterItem("customtype", (Object)fields[0]);
        queryParam.getFilter().addFilterItem(DATE_TYPE, (Object)Integer.parseInt(fields[1]));
        queryParam.getFilter().addFilterItem("orgViewNumber", (Object)this.getPageCache().get("orgViewNumber"));
        return super.verifyQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        long orgId = row.getLong(ORGID);
        String fieldName = event.getFieldName();
        if (EmptyUtil.isEmpty((String)fieldName) || !fieldName.startsWith(PREFIX)) {
            return;
        }
        ReportShowParameter param = new ReportShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
        long parentId = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
        param.getCustomParams().put("parent_id", Long.toString(parentId));
        param.getCustomParams().put("customtype", paramMap.get("customtype"));
        param.getCustomParams().put(DATE_TYPE, paramMap.get(DATE_TYPE));
        param.getCustomParams().put(TOP_BANKCATE, row.getString(TOP_BANKCATE));
        if (EmptyUtil.isEmpty((Long)orgId)) {
            param.getCustomParams().put("current_org_id", Long.toString(parentId));
        } else {
            param.getCustomParams().put("current_org_id", Long.toString(orgId));
        }
        if (this.getView().getFormShowParameter().getCustomParams().get("home") != null) {
            param.getCustomParams().put("home", Boolean.TRUE);
        }
        param.setFormId("tda_investamtotherbankrpt");
        if ("bankcate_0amount".equals(fieldName)) {
            param.getCustomParams().put(DISPLAY_TYPE, "bank");
        } else {
            param.getCustomParams().put(DISPLAY_TYPE, "finance");
            param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u91d1\u989d\u5176\u4ed6\u91d1\u878d\u673a\u6784\u5206\u5e03", (String)"InvestAmtBankFormPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString("isgroupnode");
        Object formatValue = packageDataEvent.getFormatValue();
        String fieldKey = ((ReportColumn)packageDataEvent.getSource()).getFieldKey();
        if (fieldKey.startsWith(PREFIX)) {
            return;
        }
        if (formatValue != null && !"1".equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(fieldKey);
        }
    }

    private Set<String> getRateColName(DynamicObjectCollection rowData) {
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        return properties.stream().filter(r -> StringUtils.isNotEmpty((String)r.getName()) && r.getName().startsWith("bank")).map(IMetadata::getName).collect(Collectors.toSet());
    }

    private String[] parseClickField(Map<String, Object> customParams) {
        String clickField = (String)customParams.get("click");
        if (EmptyUtil.isNoEmpty((String)clickField)) {
            return clickField.split("_");
        }
        return new String[]{"month", "41"};
    }
}

