/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class InvestByBalanceFormPlugin
extends AbstractReportFormPlugin {
    private static final String INVESTTYPE_PREFIX = "it_";
    private static final String BALANCE_SUFFIX = "bl";
    private static final String TEMPBALANCE_SUFFIX = "tb";
    private static final String ORGID = "orgid";

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            row.getDataEntityType().getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty.getName().startsWith(INVESTTYPE_PREFIX)).forEach(iDataEntityProperty -> {
                BigDecimal percent;
                String propertyName = iDataEntityProperty.getName();
                String rateStr = row.getString(propertyName);
                BigDecimal bigDecimal = percent = StringUtils.isEmpty((String)rateStr) ? BigDecimal.ZERO : row.getBigDecimal(propertyName);
                if (propertyName.endsWith(BALANCE_SUFFIX)) {
                    row.set(propertyName, (Object)percent.setScale(2, RoundingMode.HALF_UP));
                } else {
                    row.set(propertyName, (Object)(percent.setScale(2, RoundingMode.HALF_UP) + " %"));
                }
                Long orgid = row.getLong(ORGID);
                if (orgid.equals(0L) && propertyName.endsWith(TEMPBALANCE_SUFFIX)) {
                    row.set(propertyName, (Object)BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                }
            });
        }
    }
}

