/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestCostDateHelper;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestAmtOrgQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    public static final String MIXORGNAME = "mixorgname";
    private static final String AMOUNT = "avgprinciple";
    private static final String EXPECT_PROFIT = "expectprofit";
    private static final String RATE_AMOUNT = "rateamount";
    private static final String AVG_RATE = "avgrate";
    private static final String CLICK = "click";
    private static final String SYSTEM_TYPE = "tmc-tda-report";
    private static final String CUSTOM_TYPE = "customtype";
    private static final String DATE_TYPE = "datetype";
    private static final String DATE = "date";
    private static final String[] LAST_FIELD_NAMES = new String[]{"mixorgname", "avgprinciple", "expectprofit", "rateamount", "customtype", "datetype"};
    private static final DataType[] LAST_DATA_TYPES = new DataType[]{DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.IntegerType};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{MIXORGNAME, ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"InvestOrgAmoutRateQingAnlsPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u7d2f\u8ba1\u91d1\u989d", (String)"InvestOrgAmoutRateQingAnlsPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{EXPECT_PROFIT, ResManager.loadKDString((String)"\u6536\u76ca", (String)"InvestOrgAmoutRateQingAnlsPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AVG_RATE, ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestOrgAmoutRateQingAnlsPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{CUSTOM_TYPE, ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"InvestOrgAmoutRateQingAnlsPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE, ResManager.loadKDString((String)"\u65e5\u671f", (String)"InvestOrgAmoutRateQingAnlsPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE_TYPE, ResManager.loadKDString((String)"\u65e5\u671f\u6392\u5e8f", (String)"InvestOrgAmoutRateQingAnlsPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"InvestOrgAmoutRateQingAnlsPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"InvestOrgAmoutRateQingAnlsPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)CUSTOM_TYPE, (String)DATE);
        String customType = (String)typeLinkValue.getValue0();
        String date = (String)typeLinkValue.getValue1();
        return InvestCostDateHelper.getAfterFilterDataSet((DataSet)ds, (String)customType, (Boolean)true, (String)date, filterParam);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(AMOUNT);
        fields.add(EXPECT_PROFIT);
        return fields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investamtsumrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(formId);
        param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5355\u4f4d\u91d1\u989d\u53ca\u6536\u76ca\u6c47\u603b\u8868", (String)"InvestAmtOrgQingAnlsPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet allDs = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        if (allDs.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(allDs.getRowMeta().getFieldNames(), allDs.getRowMeta().getDataTypes());
        }
        allDs = allDs.select("company, avgprinciple, expectprofit,avgprinciple*expectrate rateamount, customtype, datetype");
        allDs = allDs.addField("concat(customtype,'_',datetype)", "concattype");
        allDs = allDs.select("company, avgprinciple, expectprofit,rateamount,concattype").groupBy(new String[]{"company", "concattype"}).sum(AMOUNT).sum(EXPECT_PROFIT).sum(RATE_AMOUNT).finish();
        allDs = DecisionAnlsHelper.ChangeMultRowToColDataSet(allDs, "concattype", "company", "c_", Arrays.asList(AMOUNT, EXPECT_PROFIT, RATE_AMOUNT));
        String[] fieldNames = allDs.getRowMeta().getFieldNames();
        ArrayList<String> sumField = new ArrayList<String>(126);
        for (String fieldName : fieldNames) {
            if (!fieldName.startsWith("c_")) continue;
            sumField.add(fieldName);
        }
        Collections.sort(sumField);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> selectField = InvestAmtOrgQingAnlsPlugin.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(allDs).on("rowid", "company").select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(orgJoinSet, sumField, MIXORGNAME);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        sumDataSet = CollectionUtils.isNotEmpty((Collection)secondOrgIds) ? sumDataSet.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds)) : sumDataSet.filter("rowid = id", Collections.singletonMap("id", orgId));
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])LAST_FIELD_NAMES, (DataType[])LAST_DATA_TYPES);
        DataSetBuilder builder = Algo.create((String)"InvestOrgAmoutRateQingAnlsPlugin.newDataSet").createDataSetBuilder(builderMeta);
        for (Row row : sumDataSet) {
            Object mixOrgName = row.get(MIXORGNAME);
            for (int i = 0; i < sumField.size(); i += 3) {
                ArrayList<Object> newRow = new ArrayList<Object>(LAST_FIELD_NAMES.length);
                newRow.add(mixOrgName);
                BigDecimal amount0 = row.getBigDecimal((String)sumField.get(i));
                BigDecimal amount1 = row.getBigDecimal((String)sumField.get(i + 1));
                BigDecimal amount2 = row.getBigDecimal((String)sumField.get(i + 2));
                if (((String)sumField.get(i)).contains(AMOUNT)) {
                    if (EmptyUtil.isEmpty((Object)amount0)) continue;
                    newRow.add(amount0);
                    newRow.add(amount1);
                    newRow.add(amount2);
                } else {
                    if (EmptyUtil.isEmpty((Object)amount1)) continue;
                    newRow.add(amount1);
                    newRow.add(amount0);
                    newRow.add(amount2);
                }
                String[] splitFiledPart = ((String)sumField.get(i)).split("_");
                newRow.add(splitFiledPart[1]);
                newRow.add(Integer.valueOf(splitFiledPart[2].replace(AMOUNT, "").replace(EXPECT_PROFIT, "").replace(RATE_AMOUNT, "")));
                builder.append(newRow.toArray());
            }
        }
        DataSet result = builder.build();
        if (result != null) {
            result = InvestReportDataHelper.parseDateType(result, queryDate);
            result = result.addFields(new String[]{"case when avgprinciple is null OR avgprinciple = 0 then 0.0 else rateamount/avgprinciple end", "concat(customtype,'_',datetype)"}, new String[]{AVG_RATE, CLICK}).orderBy(new String[]{AMOUNT});
        }
        return result;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("orgname");
        selectField.add(MIXORGNAME);
        selectField.add("rowid");
        selectField.add("orgid");
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }
}

