/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestBalanceByTypeQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String BALANCE = "balance";
    private static final String EXP_RATE = "frate";
    private static final String INVEST_TYPE = "investtype";
    private static final String ISOFFSET = "isoffset";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestByBalanceDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{EXP_RATE, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"InvestByBalanceDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{INVEST_TYPE, ResManager.loadKDString((String)"\u6295\u8d44\u7c7b\u578b", (String)"InvestAmtSumQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet investBalanceDataSet = InvestDataHelper.getInvestDataSet((String)((Object)((Object)this)).getClass().getName(), orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId, null).select(new String[]{AMOUNT, "amount * frate as frate", INVEST_TYPE, ISOFFSET});
        DataSet[] splitSets = investBalanceDataSet.splitByFilter(new String[]{"isoffset = '1'"}, true);
        DataSet offsetSet = splitSets[0].updateField(AMOUNT, "0").updateField(EXP_RATE, "0.0");
        investBalanceDataSet = splitSets[1].union(offsetSet);
        investBalanceDataSet = investBalanceDataSet.groupBy(new String[]{INVEST_TYPE}).sum(AMOUNT, BALANCE).sum(EXP_RATE).finish();
        investBalanceDataSet = investBalanceDataSet.updateField(EXP_RATE, "case when balance is null or balance = 0 then 0.00 else frate/balance end");
        investBalanceDataSet = InvestReportDataHelper.parseInvestType(investBalanceDataSet);
        return investBalanceDataSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(BALANCE);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investbybalancerpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return INVEST_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_investbybalancerpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u54c1\u79cd\u4f59\u989d\u5206\u5e03\u8868", (String)"InvestBalanceByTypeQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }
}

