/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestBankBalanceQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String BANKNAME = "bankname";
    private static final String AMOUNT = "amount";
    private static final int TOP = 10;

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BANKNAME, ResManager.loadKDString((String)"\u673a\u6784\u540d\u79f0", (String)"InvestBankAmountQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"InvestBankAmountQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"InvestBankAmountQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet domesticUnionSet;
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String className = ((Object)((Object)this)).getClass().getName();
        DataSet ds = InvestDataHelper.getInvestBalanceDataSet((String)className, orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        String selectStr = "finorgtype,bankcatename bankname,bankcateid bankcate,amount";
        ds = ds.select(selectStr);
        DataSet[] splitDataSets = ds.splitByFilter(new String[]{"finorgtype = '0'", "finorgtype = '3'", "finorgtype = '1'"}, true);
        DataSet bankDataSte = splitDataSets[0];
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitTopBank(bankDataSte, AMOUNT, 10);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).groupBy(new String[]{BANKNAME}).sum(AMOUNT).finish().orderBy(new String[]{"amount desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet otherDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"InvestBankAmountQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANKNAME}).sum(AMOUNT).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(otherDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        DataSet financeDataSet = splitDataSets[1].updateField(BANKNAME, "'" + FinOrgTypeEnum.FINCOMP.getName() + "'").groupBy(new String[]{BANKNAME}).sum(AMOUNT).finish();
        DataSet clearingHouseSet = splitDataSets[2].updateField(BANKNAME, "'" + FinOrgTypeEnum.CLEARINGHOUSE.getName() + "'").groupBy(new String[]{BANKNAME}).sum(AMOUNT).finish();
        DataSet otherFinorgDataSet = splitDataSets[3].updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u91d1\u878d\u673a\u6784'", (String)"InvestBankAmountQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANKNAME}).sum(AMOUNT).finish();
        return domesticUnionSet.union(new DataSet[]{financeDataSet, clearingHouseSet, otherFinorgDataSet});
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investbankbalancerpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BANKNAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_investbankbalancerpt");
        this.fireLinkageShowForm(view, param);
    }
}

