/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InvestByBalanceDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String BALANCE = "banalce";
    private static final String ISOFFSET = "isoffset";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u4f59\u989d", (String)"InvestByBalanceDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet investBalanceDataSet = InvestDataHelper.getInvestBalanceDataSet((String)this.createAlgoKey(""), allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId).select(new String[]{AMOUNT, ISOFFSET});
        investBalanceDataSet = investBalanceDataSet.updateField(AMOUNT, "case when isoffset = '1' then 0.00 else amount end");
        investBalanceDataSet = investBalanceDataSet.groupBy().sum(AMOUNT, BALANCE).finish();
        return investBalanceDataSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(BALANCE);
    }

    @Override
    protected List<String> getLinkReport() {
        List<String> objects = Collections.singletonList("tda_investbybalancerpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BALANCE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_investbybalancerpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u4f59\u989d\u8868", (String)"InvestByBalanceDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }
}

