/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.invest.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.InvestCostDateHelper;
import kd.tmc.tda.common.helper.InvestDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.invest.helper.InvestReportDataHelper;

public class InvestRateTrendQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DATE = "date";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{DATE, ResManager.loadKDString((String)"\u671f\u95f4", (String)"InvestRateTrendQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"datetype", ResManager.loadKDString((String)"\u65e5\u671f\u6392\u5e8f", (String)"InvestRateTrendQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"avgrate", ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"InvestRateTrendQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u6295\u8d44\u603b\u989d", (String)"InvestRateTrendQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"profit", ResManager.loadKDString((String)"\u6295\u8d44\u6536\u76ca", (String)"InvestRateTrendQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"customtype", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"InvestRateTrendQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"customtypename", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u540d\u79f0", (String)"InvestRateTrendQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"customtypenum", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u7f16\u53f7", (String)"InvestRateTrendQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = InvestDataHelper.getInvestDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (DateRangeEnum)DateRangeEnum.ALL);
        allDs = allDs.select("customtype,datetype,avgprinciple amount,expectprofit profit,expectrate rate");
        DataSet groupDs = allDs.groupBy(new String[]{"customtype", "datetype"}).sum("amount").sum("profit").sum("amount*rate", "rateamount").finish();
        groupDs = this.dealEmptyRow(groupDs);
        DataSet ds = InvestReportDataHelper.parseDateType(groupDs, queryDate);
        String customTypeTemplate = "case when customtype='year' then '%1$s' when customtype='half' then '%2$s' when customtype='season' then '%3$s' when customtype='month' then '%4$s' else ' ' end";
        String customTypeName = String.format(customTypeTemplate, DateRangeEnum.YEAR.getText(), DateRangeEnum.HALF_YEAR.getText(), DateRangeEnum.SEASON.getText(), DateRangeEnum.MONTH.getText());
        String customTypeNum = String.format(customTypeTemplate, DateRangeEnum.YEAR.getIndex(), DateRangeEnum.HALF_YEAR.getIndex(), DateRangeEnum.SEASON.getIndex(), DateRangeEnum.MONTH.getIndex());
        return ds.addFields(new String[]{"case when amount is null or amount=0 then 0.00 else rateamount/amount end", customTypeName, customTypeNum}, new String[]{"avgrate", "customtypename", "customtypenum"});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)"customtype", (String)DATE);
        String customType = (String)typeLinkValue.getValue0();
        return InvestCostDateHelper.getAfterFilterDataSet((DataSet)ds, (String)customType, (Boolean)false, null, filterParam);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_investraterpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "customtype";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put("customtype", ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("amount");
        fields.add("profit");
        return fields;
    }

    private DataSet dealEmptyRow(DataSet ds) {
        List<DateRangeEnum> customTypes = Arrays.asList(DateRangeEnum.YEAR, DateRangeEnum.HALF_YEAR, DateRangeEnum.SEASON, DateRangeEnum.MONTH);
        RowMeta rowMeta = ds.getRowMeta();
        for (int i = 0; i < customTypes.size(); ++i) {
            DateRangeEnum dateRangeEnum = customTypes.get(i);
            int start = dateRangeEnum.getStart();
            int end = dateRangeEnum.getEnd();
            for (int k = start; k <= end; ++k) {
                String filterConditions = String.format("customtype='%1$s' and datetype=%2$s", dateRangeEnum.getValue(), k);
                if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{dateRangeEnum.getValue(), k, 0.0, 0.0, 0.0}));
                ds = ds.union(bizDs);
            }
        }
        return ds;
    }
}

