/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.data;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.liquidity.helper.LiquidityDateHelper;
import kd.tmc.tda.report.liquidity.helper.LiquidityIndexDataHelper;

public class AbstractLiquidityDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final List<String> ORG_SELECTFIELD = Arrays.asList("orgid", "rowid", "mixorgname", "orgname", "pid", "isgroupnode", "level", "0  as sumlevel");
    protected static final String TMC_TDA_REPORT = "tmc-tda-report";
    private String analySisIndexName = this.getAnalysisIndexName();
    private LiquidityIndexDataHelper indexDataHelper = new LiquidityIndexDataHelper(this.analySisIndexName);

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date realQueryDate = LiquidityDataCheckHelper.getRealQueryDate((Map)paramMap);
        paramMap.put("querydate", realQueryDate);
        return this.indexDataHelper.queryDataSet(paramMap, this.createAlgoKey("Liquidity"));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam param = this.getQueryParam();
        Map paramMap = this.transQueryParam(param);
        Date queryDate = LiquidityDataCheckHelper.getRealQueryDate((Map)paramMap);
        Map<String, Integer> periodMap = LiquidityDateHelper.getYearAndMonth(queryDate);
        Integer year = periodMap.get("year");
        Integer lastMonth = periodMap.get("lastmonth");
        Integer month = periodMap.get("month");
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup)) continue;
            column.setCaption(this.getReportGroupCaption());
            ReportColumnGroup rcp = (ReportColumnGroup)column;
            List children = rcp.getChildren();
            for (AbstractReportColumn col : children) {
                String fieldKey = "";
                if (col instanceof ReportColumn) {
                    fieldKey = ((ReportColumn)col).getFieldKey();
                }
                switch (fieldKey) {
                    case "decimalfield": {
                        col.setCaption(new LocaleString(year.toString() + "-" + month.toString()));
                        break;
                    }
                    case "decimalfield1": {
                        col.setCaption(new LocaleString(LiquidityDateHelper.getLastPeriodYear(periodMap).toString() + "-" + lastMonth.toString()));
                        break;
                    }
                    case "decimalfield2": {
                        col.setCaption(new LocaleString(year - 1 + "-12"));
                        break;
                    }
                    case "decimalfield3": {
                        col.setCaption(new LocaleString(year - 2 + "-12"));
                        break;
                    }
                    case "decimalfield4": {
                        col.setCaption(new LocaleString(year - 3 + "-12"));
                        break;
                    }
                    case "decimalfield5": {
                        col.setCaption(new LocaleString(year - 4 + "-12"));
                        break;
                    }
                    case "decimalfield6": {
                        col.setCaption(new LocaleString(year - 5 + "-12"));
                        break;
                    }
                }
            }
        }
        return columns;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet allAcctSet, ReportQueryParam queryParam) {
        return this.indexDataHelper.queryFilterDataSet(allAcctSet, queryParam, this.createAlgoKey("LiquidityFilter"));
    }

    protected LocaleString getReportGroupCaption() {
        return null;
    }

    protected String getAnalysisIndexName() {
        return null;
    }
}

