/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.LiquidityDataCheckHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.liquidity.helper.LiquidityIndicatorDetailHelper;

public class LiquidityIndicatorDetailDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date realQueryDate = LiquidityDataCheckHelper.getRealQueryDate((Map)paramMap);
        paramMap.put("querydate", realQueryDate);
        return LiquidityIndicatorDetailHelper.getDataSet(paramMap);
    }

    @Override
    protected String orgField() {
        return "orgid";
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("duethreemonthamt");
    }

    @Override
    protected DataSet filterResultDataSet(DataSet sumDataSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List filterOrg = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            DynamicObject org = (DynamicObject)paramMap.get("org");
            filterOrg.add((Long)org.getPkValue());
            sumDataSet = sumDataSet.filter("rowid in (" + TmcBusinessBaseHelper.idListToString((List)filterOrg) + ")");
        }
        return sumDataSet;
    }

    @Override
    protected DataSet removeAllZeroRow(DataSet dataSet, Set<String> fieldNames) {
        final Set<String> finalFieldNames = this.getCountZeroFields();
        return dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                for (String fieldName : finalFieldNames) {
                    BigDecimal bigDecimal = row.getBigDecimal(fieldName);
                    if (bigDecimal == null || BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private Set<String> getCountZeroFields() {
        HashSet<String> fields = new HashSet<String>(25);
        fields.add("assetsdebtrate");
        fields.add("intdebtrate");
        fields.add("assetsdebtrateyear");
        fields.add("intdebtrateyear");
        fields.add("quickratio");
        fields.add("quickratioyear");
        fields.add("flowratio");
        fields.add("flowratioyear");
        fields.add("intcoverratio");
        fields.add("intcoverratioyear");
        fields.add("duethreemonthamt");
        fields.add("duethreemonthamtyear");
        fields.add("fundduethreemthratio");
        fields.add("fundduethreemthratioyear");
        fields.add("duethreemonthratio");
        fields.add("duethreemonthratioyear");
        fields.add("assetsdebtratemonth");
        fields.add("intdebtratemonth");
        fields.add("quickratiomonth");
        fields.add("flowratiomonth");
        fields.add("intcoverratiomonth");
        fields.add("duethreemonthamtmonth");
        fields.add("fundduethreemthratiomonth");
        fields.add("duethreemonthratiomonth");
        return fields;
    }
}

