/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.form;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.SnapDataHelper;

public class LiquidityAlmFormPlugin
extends AbstractReportFormPlugin {
    private static final List<String> FORMLIST = Arrays.asList("tda_liquidity_alm", "tda_liquidity_liability", "tda_liquidity_dtmr");
    private static final List<String> COLUMNLIST = Arrays.asList("decimalfield", "decimalfield1", "decimalfield2", "decimalfield3", "decimalfield4", "decimalfield5", "decimalfield6");
    public static final String ORGID = "orgid";

    public void packageData(PackageDataEvent packageDataEvent) {
        Object value;
        String entityId = this.getView().getEntityId();
        ReportColumn column = (ReportColumn)packageDataEvent.getSource();
        if (FORMLIST.contains(entityId) && COLUMNLIST.contains(column.getFieldKey()) && (value = packageDataEvent.getFormatValue()) instanceof Object[]) {
            Object[] val = (Object[])value;
            BigDecimal originVal = (BigDecimal)val[1];
            val[0] = originVal.movePointRight(2).setScale(2, 4) + "%";
        }
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        long orgid = row.getLong(ORGID);
        Map map = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
        DynamicObject org = (DynamicObject)map.get("org");
        if (orgid == org.getLong("id")) {
            packageDataEvent.getNoLinkKey().add(((ReportColumn)packageDataEvent.getSource()).getFieldKey());
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        ReportView reportView = (ReportView)this.getView();
        ReportListModel reportModel = (ReportListModel)reportView.getReportList().getReportModel();
        List reportColumnList = reportModel.getReportTaskResult().getReportColumnList();
        Set columns = reportColumnList.stream().map(reportColumn -> reportColumn.getFieldKey()).collect(Collectors.toSet());
        String conditionStr = "isgroupnode = '-1'";
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.stream().forEach(fieldKey -> {
                CellStyleRule cellStyleRule = this.createCellStyleRule("#eb743f", (String)fieldKey, conditionStr);
                cellStyleRules.add(cellStyleRule);
            });
        }
        super.setCellStyleRules(cellStyleRules);
    }

    private CellStyleRule createCellStyleRule(String color, String fieldKey, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(fieldKey);
        cellStyleRule.setForeColor(color);
        cellStyleRule.setBackgroundColor("#f3f6db");
        cellStyleRule.setDegree(100);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }
}

