/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.liquidity.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LiquidityIndicatorDetailFormListPlugin
extends AbstractReportFormPlugin {
    public static final String[] SRFIELDS = new String[]{"assetsdebtrate", "assetsdebtrateyear", "assetsdebtratemonth", "intdebtrate", "intdebtrateyear", "intdebtratemonth", "quickratioyear", "quickratiomonth", "flowratioyear", "flowratiomonth", "intcoverratioyear", "intcoverratiomonth", "duethreemonthamtyear", "duethreemonthamtmonth", "fundduethreemthratioyear", "fundduethreemthratiomonth", "duethreemonthratio", "duethreemonthratioyear", "duethreemonthratiomonth"};
    public static final String[] BIGFIELDS = new String[]{"quickratio", "flowratio", "intcoverratio", "fundduethreemthratio"};

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            BigDecimal bigvalue;
            String value;
            for (String field : SRFIELDS) {
                value = row.getString(field);
                bigvalue = EmptyUtil.isEmpty((String)value) ? BigDecimal.ZERO : new BigDecimal(value);
                row.set(field, (Object)(bigvalue.setScale(2, RoundingMode.HALF_UP) + "%"));
            }
            for (String field : BIGFIELDS) {
                value = row.getString(field);
                bigvalue = EmptyUtil.isEmpty((String)value) ? BigDecimal.ZERO : new BigDecimal(value);
                row.set(field, (Object)bigvalue.setScale(2, RoundingMode.HALF_UP));
            }
            String value2 = row.getString("duethreemonthamt");
            BigDecimal bigvalue2 = EmptyUtil.isEmpty((String)value2) ? BigDecimal.ZERO : new BigDecimal(value2);
            row.set("duethreemonthamt", (Object)bigvalue2.stripTrailingZeros().toPlainString());
        }
    }
}

