/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.BillCustRankHelper;

public class BillBalanceCustRankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String RPTYPE = "rptype";
    private static final String BILLTYPE = "billtype";
    private static final String DELIVERNAME = "delivername";
    private static final String DELIVERID = "deliver";
    private static final String RECEIVERNAME = "receivername";
    private static final String RECEIVER = "receiver";
    private static final String AMOUNT = "amount";
    private static final String DISPLAYTYPE = "displayType";
    private static final int TOP = 10;
    private static final String ORGID = "orgid";
    private static final String OHTERDELIVER_ID = "0";
    private static final String PREFIX = "deliver_";
    private static final String ROWID = "rowid";
    private static final String STAT = "bankcate_stat";
    private static final String PAYBILL = "paybill";
    private static final String ALLTYPE = "all";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List allorgids = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String rptype = (String)paramMap.get(RPTYPE);
        DataSet allDs = DraftBillDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (String)rptype);
        allDs = allDs.filter("billtype in ('5', '6', '20')").select(new String[]{BILLTYPE, AMOUNT, DELIVERNAME, ORGID, DELIVERID, RECEIVERNAME, RECEIVER});
        return allDs.groupBy(new String[]{BILLTYPE, DELIVERNAME, ORGID, DELIVERID, RECEIVERNAME, RECEIVER}).sum(AMOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DataSet deliverUnionSet;
        String rptype;
        Map paramMap = this.transQueryParam(queryParam);
        String displayType = (String)paramMap.get(DISPLAYTYPE);
        if (StringUtil.isEmpty((String)displayType)) {
            displayType = ALLTYPE;
        }
        if (!ALLTYPE.equals(displayType)) {
            ds = ds.filter("billtype = displayType", Collections.singletonMap(DISPLAYTYPE, displayType));
        }
        if (PAYBILL.equals(rptype = (String)paramMap.get(RPTYPE))) {
            ds = ds.updateFields(new String[]{DELIVERNAME, DELIVERID}, new String[]{RECEIVERNAME, RECEIVER});
        }
        ds = ds.select(new String[]{AMOUNT, DELIVERNAME, ORGID, DELIVERID});
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, Collections.singleton(AMOUNT));
        DataSet copy = ds.copy();
        Pair<DataSet, DataSet> splitDeliverDataSet = BillCustRankHelper.splitTopDeliver(ds, AMOUNT, 10);
        DataSet topDeliverDataSet = ((DataSet)splitDeliverDataSet.getValue0()).groupBy(new String[]{ORGID, DELIVERNAME, DELIVERID}).sum(AMOUNT).finish().orderBy(new String[]{"amount desc", DELIVERNAME});
        if (splitDeliverDataSet.getValue1() != null) {
            DataSet otherDeliverSet = ((DataSet)splitDeliverDataSet.getValue1()).updateFields(new String[]{DELIVERNAME, DELIVERID}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6'", (String)"BillBalanceCustRankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERDELIVER_ID}).groupBy(new String[]{ORGID, DELIVERNAME, DELIVERID}).sum(AMOUNT).finish();
            deliverUnionSet = topDeliverDataSet.union(otherDeliverSet);
        } else {
            deliverUnionSet = topDeliverDataSet;
        }
        DataSet afterChangeRowToColSet = DecisionAnlsHelper.ChangeMultRowToColDataSet(deliverUnionSet, DELIVERID, ORGID, PREFIX, Collections.singletonList(AMOUNT));
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = BillCustRankHelper.getSumField(afterChangeRowToColSet);
        List<String> selectField = BillCustRankHelper.getSelectField(sumField);
        selectField.add("sortcode");
        afterChangeRowToColSet = BillCustRankHelper.groupby(afterChangeRowToColSet, new String[]{ORGID}, sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(afterChangeRowToColSet).on(ROWID, ORGID).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgids));
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(AMOUNT)).collect(Collectors.toSet());
        sumDataSet = sumDataSet.addField(CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : OHTERDELIVER_ID, STAT);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = this.removeAllZeroRow(sumDataSet, sumField.stream().collect(Collectors.toSet()));
        sumField.add(STAT);
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = BillCustRankHelper.getCols(totalSet.copy(), copy);
        queryParam.getCustomParam().put("topDeliverMap", cols);
        return sumDataSet.union(totalSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topDeliverMap");
        return BillCustRankHelper.getBillCustRankColumns(columns, cols);
    }
}

