/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.DraftBillLetterCreditDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class LetterCreditDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final String ORGID = "orgid";
    protected static final String ISFORWARD = "isforward";
    protected static final String FARAMOUNT = "faramount";
    protected static final String SPOTAMOUNT = "spotamount";
    protected static final String FARCOUNT = "farcount";
    protected static final String SPOTCOUNT = "spotcount";
    private static final String TOTALAMOUNT = "totalamount";
    private static final String TOTALCOUNT = "totalcount";
    private static final List<String> SUM_FIELD = Arrays.asList("spotamount", "faramount", "spotcount", "farcount");
    private static final List<String> TOTAL_SUM_FIELD = Arrays.asList("spotamount", "faramount", "spotcount", "farcount", "totalamount", "totalcount");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet letterCreditDataSet = this.getLetterCreditDataSet(orgViewId, baseCurrency, queryDate, orgIds);
        letterCreditDataSet = letterCreditDataSet.groupBy(new String[]{ORGID, "dateRange"}).sum(FARAMOUNT).sum(SPOTAMOUNT).sum(FARCOUNT).sum(SPOTCOUNT).finish();
        return letterCreditDataSet;
    }

    protected DataSet getLetterCreditDataSet(Long orgViewId, Long baseCurrency, Date queryDate, List<Long> orgIds) {
        DataSet billBalanceDataSet = DraftBillLetterCreditDataHelper.getBillAccruedDataSet((String)this.createAlgoKey(""), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        billBalanceDataSet = billBalanceDataSet.select(new String[]{ORGID, ISFORWARD, "bizdate", "amount", FARCOUNT, SPOTCOUNT}).addFields(new String[]{"case when isforward = true then amount else 0.0 end", "case when isforward = false then amount else 0.0 end"}, new String[]{FARAMOUNT, SPOTAMOUNT});
        Map dateMap = DecisionCommonHelper.getDateRangeMap((Date)queryDate);
        billBalanceDataSet = DecisionCommonHelper.getDateRangeDataSets((DataSet)billBalanceDataSet, (Map)dateMap, (String)"bizdate");
        return billBalanceDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet sumDataSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String dateRange = (String)paramMap.get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = "one_month";
        }
        sumDataSet = sumDataSet.filter("dateRange ='" + dateRange + "'");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        sumDataSet = orgDateSet.leftJoin(sumDataSet).on(ORGID, ORGID).select(new String[]{ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode", FARAMOUNT, SPOTAMOUNT, FARCOUNT, SPOTCOUNT, "0  as sumlevel"}).finish();
        sumDataSet = this.getSumDataSetByLevel(sumDataSet, SUM_FIELD, "orgid,mixorgname,sortcode");
        sumDataSet = sumDataSet.addFields(new String[]{"faramount + spotamount", "farcount + spotcount"}, new String[]{TOTALAMOUNT, TOTALCOUNT});
        List filterOrg = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            sumDataSet = sumDataSet.filter("rowid in (" + TmcBusinessBaseHelper.idListToString((List)filterOrg) + ")").filter("totalcount > 0");
        }
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        DataSet totalSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, TOTAL_SUM_FIELD, "mixorgname");
        DataSet resultSet = sumDataSet.union(totalSet).addFields(new String[]{"(spotamount*1.0/totalamount)*100", "(faramount*1.0/totalamount)*100"}, new String[]{"spotratio", "farratio"});
        return resultSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> set = new HashSet<String>(8);
        set.add(SPOTAMOUNT);
        set.add(FARAMOUNT);
        set.add(TOTALAMOUNT);
        return set;
    }

    protected String getAmountType() {
        return "accrued";
    }
}

