/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.tmc.tda.common.helper.DraftBillLetterCreditDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class LetterCreditDetailDataListPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba", (String)"LetterCreditDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"LetterCreditDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"creditno", ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u53f7", (String)"LetterCreditDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"lettercount", ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u7b14\u6570", (String)"LetterCreditDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"applydate", ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u671f", (String)"LetterCreditDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"credittypename", ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u7c7b\u578b", (String)"LetterCreditDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u5f00\u8bc1\u65e5\u671f", (String)"LetterCreditDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"isforward", ResManager.loadKDString((String)"\u662f\u5426\u8fdc\u671f", (String)"LetterCreditDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"forwarddays", ResManager.loadKDString((String)"\u8fdc\u671f\u5929\u6570", (String)"LetterCreditDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"LetterCreditDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u5f00\u8bc1\u884c", (String)"LetterCreditDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"amount", "balance".equals(this.getAmountType()) ? ResManager.loadKDString((String)"\u5f00\u8bc1\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"LetterCreditDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f00\u8bc1\u53d1\u751f\u989d\u6298\u62a5\u544a\u5e01", (String)"LetterCreditDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"noticebank", ResManager.loadKDString((String)"\u901a\u77e5\u884c", (String)"LetterCreditDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"benefiterother", ResManager.loadKDString((String)"\u53d7\u76ca\u4eba", (String)"LetterCreditDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"amountscalelow", ResManager.loadKDString((String)"\u6ea2\u77ed\u88c5\u4e0b\u9650%", (String)"LetterCreditDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amountscaleupper", ResManager.loadKDString((String)"\u6ea2\u77ed\u88c5\u4e0a\u9650%", (String)"LetterCreditDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"creditstatus", ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u72b6\u6001", (String)"LetterCreditDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, DecisionAnlsHelper.getEnumItemsByProperty("lc_lettercredit", "creditstatus")});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List allOrgIds = (List)paramMap.get("allorgids");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String dateRange = (String)paramMap.get("dateRange");
        DataSet dataSet = this.getLetterCreditDataSet(allOrgIds, queryDate, baseCurrency, orgViewId, dateRange);
        DataSet resultSet = dataSet.addFields(new String[]{"orgid", "1"}, new String[]{"company", "lettercount"});
        return resultSet;
    }

    protected DataSet getLetterCreditDataSet(List<Long> orgIds, Date queryDate, Long baseCurrency, Long orgViewId, String dateRange) {
        return DraftBillLetterCreditDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId).updateFields(new String[]{"amount"}, new String[]{"balance"});
    }

    @Override
    protected String getCountField() {
        return "lettercount";
    }

    @Override
    protected List<String> getSumLists() {
        return Collections.singletonList("amount");
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("credittypename", "bankname");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("billno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        return hyperlinkEntity -> "lc_lettercredit";
    }

    protected String getAmountType() {
        return "balance";
    }
}

