/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class ReceiveDiscountDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String RECBODYBANKCATEID = "recbodybankcateid";
    private static final String RECBODYBANKCATENAME = "recbodybankcatename";
    private static final String CUSTOMTYPE = "customtype";
    private static final String TERM = "term";
    private static final String BILLTYPE = "billtype";
    private static final String DISCOUNT_DAYS = "discountdays";
    private static final String DISCOUNT_RATE = "discountrate";
    private static final String DISCOUNT_INTEREST = "discountinterest";
    private static final String MOLECULE = "molecule";
    private static final String DENOMINATOR = "denominator";
    private static final String BANKNAME = "bankname";
    private static final String BANKCATE = "bankcate";
    private static final String AMOUNT = "amount";
    private static final String ORGID = "orgid";
    private static final int TOP = 10;
    private static final String ROWID = "rowid";
    private static final String STAT = "bankcate_stat";
    private static final String INTEREST_STAT = "bankcate_stat_int";
    private static final String MOLECULE_STAT = "bankcate_stat_mol";
    private static final String DENOMINATOR_STAT = "bankcate_stat_den";
    private static final String PREFIX = "bankcate_";
    private static final String OHTERBANK_ID = "0";
    private static final String FINANCE_ID = "5";
    private static final String FINCOMP_ID = "20";
    private static final String INTEREST_SUFFIX = "int";
    private static final String MOLECULE_SUFFIX = "mol";
    private static final String DENOMINATOR_SUFFIX = "den";
    private static final String AVG_SUFFIX = "avg";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet detaiData = DraftBillDataHelper.getRecBillDiscountDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        DataSet[] detaiDatas = DraftBillDataHelper.getDateRangeDataSet((DataSet)detaiData, (Date)queryDate, null, (boolean)true);
        DataSet termTypeGroupDS = detaiDatas[0].addField("''", TERM);
        termTypeGroupDS = DraftBillUpdateFieldFunction.updateFields((DataSet)termTypeGroupDS, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.dateTypeUpdateFunction((Date)queryDate, (String)TERM)});
        if (EmptyUtil.isNoEmpty((String)dateRange)) {
            termTypeGroupDS = this.filterDateRange(dateRange, termTypeGroupDS);
        }
        DataSet result = termTypeGroupDS.select(new String[]{ORGID, "recbodybankcateid as bankcate", "recbodybankcatename as bankname", AMOUNT, CUSTOMTYPE, TERM, BILLTYPE, DISCOUNT_DAYS, DISCOUNT_RATE, DISCOUNT_INTEREST}).addFields(new String[]{"amount*discountdays*discountrate", "amount*discountdays"}, new String[]{MOLECULE, DENOMINATOR}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE, BILLTYPE, CUSTOMTYPE, TERM}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish();
        return result;
    }

    private DataSet filterDateRange(String dateRange, DataSet termTypeGroupDS) {
        String[] splitDateRange = dateRange.split("_");
        String termType = splitDateRange[0];
        String term = splitDateRange[1];
        String filter = "customtype = '" + termType + "' and term = '" + term + "'";
        termTypeGroupDS = termTypeGroupDS.filter(filter);
        return termTypeGroupDS;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet result, ReportQueryParam queryParam) {
        DataSet domesticUnionSet;
        Map paramMap = this.transQueryParam(queryParam);
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        if (EmptyUtil.isNoEmpty((String)dateRange)) {
            result = this.filterDateRange(dateRange, result);
        }
        DataSet[] splitDataSets = result.splitByFilter(new String[]{"billtype = '6'", "billtype = '20'", "billtype = '5'"}, false);
        DataSet bankDataSte = splitDataSets[0];
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitTopBank(bankDataSte, AMOUNT, 10);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish().orderBy(new String[]{"amount desc", "bankcate desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet otherDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), OHTERBANK_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(otherDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        DataSet financeDataSet = splitDataSets[1].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), FINCOMP_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish();
        DataSet clearingHouseSet = splitDataSets[2].updateFields(new String[]{BANKNAME, BANKCATE}, new String[]{ResManager.loadKDString((String)"'\u5546\u4e1a\u7968\u636e'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), FINANCE_ID}).groupBy(new String[]{ORGID, BANKNAME, BANKCATE}).sum(AMOUNT).sum(DISCOUNT_INTEREST).sum(MOLECULE).sum(DENOMINATOR).finish();
        DataSet ds = domesticUnionSet.union(new DataSet[]{financeDataSet, clearingHouseSet});
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, new HashSet<String>(Arrays.asList(AMOUNT, DISCOUNT_INTEREST, MOLECULE, DENOMINATOR)));
        DataSet copy = ds.copy();
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put(ReceiveDiscountDataListPlugin.AMOUNT, ReceiveDiscountDataListPlugin.AMOUNT);
                this.put(ReceiveDiscountDataListPlugin.DISCOUNT_INTEREST, ReceiveDiscountDataListPlugin.INTEREST_SUFFIX);
                this.put(ReceiveDiscountDataListPlugin.MOLECULE, ReceiveDiscountDataListPlugin.MOLECULE_SUFFIX);
                this.put(ReceiveDiscountDataListPlugin.DENOMINATOR, ReceiveDiscountDataListPlugin.DENOMINATOR_SUFFIX);
            }
        };
        DataSet afterChangeRowToColSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(ds, BANKCATE, ORGID, PREFIX, (Map<String, String>)map);
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = this.getSumField(afterChangeRowToColSet);
        List<String> selectField = this.getSelectField(sumField);
        selectField.add("sortcode");
        afterChangeRowToColSet = this.groupby(afterChangeRowToColSet, new String[]{ORGID}, sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(afterChangeRowToColSet).on(ROWID, ORGID).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode,orgname,mixorgname,rowid orgid");
        List subOrgids = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgids)) {
            subOrgids = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgids));
        sumDataSet = sumDataSet.addFields(new String[]{this.getTotalColExpr(sumField, AMOUNT), this.getTotalColExpr(sumField, INTEREST_SUFFIX), this.getTotalColExpr(sumField, MOLECULE_SUFFIX), this.getTotalColExpr(sumField, DENOMINATOR_SUFFIX)}, new String[]{STAT, INTEREST_STAT, MOLECULE_STAT, DENOMINATOR_STAT});
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = this.removeAllZeroRow(sumDataSet, sumField.stream().collect(Collectors.toSet()));
        sumField.addAll(Arrays.asList(STAT, INTEREST_STAT, MOLECULE_STAT, DENOMINATOR_STAT));
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, sumField, "mixorgname");
        totalSet = DecisionAnlsHelper.updateValueWhenNull(totalSet, sumField);
        List<AbstractReportColumn> cols = this.getCols(totalSet.copy(), copy);
        queryParam.getCustomParam().put("topBankMap", cols);
        DataSet resultDataSet = sumDataSet.union(totalSet);
        Map<String, String> interestMap = ReceiveDiscountDataListPlugin.getAvgColsMap(resultDataSet.getRowMeta().getFieldNames());
        resultDataSet = resultDataSet.addFields(interestMap.values().toArray(new String[0]), interestMap.keySet().toArray(new String[0]));
        return resultDataSet;
    }

    private static Map<String, String> getAvgColsMap(String[] fieldNames) {
        return Arrays.stream(fieldNames).filter(fieldName -> fieldName.endsWith(MOLECULE_SUFFIX)).map(moleculeFieldName -> new Pair(moleculeFieldName, (Object)moleculeFieldName.replace(MOLECULE_SUFFIX, DENOMINATOR_SUFFIX))).collect(Collectors.toMap(pair -> ((String)pair.getValue0()).replace(MOLECULE_SUFFIX, AVG_SUFFIX), pair -> "case when " + (String)pair.getValue0() + " is null or " + (String)pair.getValue1() + " is null or " + (String)pair.getValue0() + " = 0.0 or " + (String)pair.getValue1() + " = 0.0 then 0.0 else " + (String)pair.getValue0() + "/" + (String)pair.getValue1() + " end", (u1, u2) -> u1, LinkedHashMap::new));
    }

    private String getTotalColExpr(List<String> sumField, String colSuffix) {
        Set sumColSet = sumField.stream().filter(f -> f.endsWith(colSuffix)).collect(Collectors.toSet());
        return CollectionUtils.isNotEmpty(sumColSet) ? String.join((CharSequence)"+", sumColSet) : OHTERBANK_ID;
    }

    private DataSet groupby(DataSet groupDataSet, String[] groupStrs, List<String> sumFields) {
        GroupbyDataSet groupbyDataSet = groupDataSet.groupBy(groupStrs);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    private List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add(ORGID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    private List<AbstractReportColumn> getCols(DataSet totalSet, DataSet allData) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        Map<Long, String> bankMap = this.getBankColKayAndNameMap(allData);
        Set<String> bankCols = this.getBankCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()), AMOUNT);
        ArrayList<AbstractReportColumn> datas = new ArrayList<AbstractReportColumn>();
        String otherBankCateColKey = this.getBankcateAmountColName(OHTERBANK_ID);
        if (CollectionUtils.isNotEmpty(bankCols)) {
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            bankCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherBankCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            Collections.sort(totalRowData, (o1, o2) -> {
                int x = ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1());
                if (x == 0) {
                    return ((String)o2.getValue0()).compareTo((String)o1.getValue0());
                }
                return x;
            });
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String bankCateIdStr = colKey.substring(PREFIX.length(), colKey.indexOf("_amount"));
                Long bankCateId = Long.valueOf(bankCateIdStr);
                this.createTargetColumnGroup(datas, colKey, bankMap.get(bankCateId), false);
            }
        }
        if (this.colExists(totalSet, OHTERBANK_ID)) {
            this.createTargetColumnGroup(datas, this.getBankcateAmountColName(OHTERBANK_ID), ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"ReceiveDiscountDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), false);
        }
        if (this.colExists(totalSet, FINCOMP_ID)) {
            this.createTargetColumnGroup(datas, this.getBankcateAmountColName(FINCOMP_ID), ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"ReceiveDiscountDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), false);
        }
        if (this.colExists(totalSet, FINANCE_ID)) {
            this.createTargetColumnGroup(datas, this.getBankcateAmountColName(FINANCE_ID), ResManager.loadKDString((String)"\u5546\u4e1a\u7968\u636e", (String)"ReceiveDiscountDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), false);
        }
        return datas;
    }

    private void createTargetColumnGroup(List<AbstractReportColumn> datas, String colKey, String groupCaption, boolean isTotalCol) {
        ReportColumnGroup reportColumnGroup = this.createReportColumnGroup(datas, isTotalCol ? colKey + "_total" : colKey.substring(0, colKey.indexOf("_amount")), groupCaption);
        reportColumnGroup.getChildren().add(this.createColumn(colKey, ResManager.loadKDString((String)"\u8d34\u73b0\u91d1\u989d", (String)"ReceiveDiscountDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0])));
        reportColumnGroup.getChildren().add(this.createColumn(isTotalCol ? colKey + "_" + INTEREST_SUFFIX : colKey.replace(AMOUNT, INTEREST_SUFFIX), ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u606f", (String)"ReceiveDiscountDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])));
        reportColumnGroup.getChildren().add(this.createColumn(isTotalCol ? colKey + "_" + AVG_SUFFIX : colKey.replace(AMOUNT, AVG_SUFFIX), ResManager.loadKDString((String)"\u8d34\u73b0\u5e73\u5747\u5229\u7387(%)", (String)"ReceiveDiscountDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])));
    }

    private Map<Long, String> getBankColKayAndNameMap(DataSet allData) {
        HashMap<Long, String> bankMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                bankMap.put(row.getLong(BANKCATE), row.getString(BANKNAME));
            }
        }
        return bankMap;
    }

    private boolean colExists(DataSet dataSet, String bankCateId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + bankCateId + "_" + AMOUNT, false) != -1;
    }

    private Set<String> getBankCols(List<String> sumField, String suffix) {
        return sumField.stream().filter(f -> f.endsWith(suffix) && !this.getBankcateAmountColName(FINCOMP_ID).equals(f) && !this.getBankcateAmountColName(FINANCE_ID).equals(f)).collect(Collectors.toSet());
    }

    private String getBankcateAmountColName(String bankCateId) {
        return PREFIX + bankCateId + "_" + AMOUNT;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = (List)this.getQueryParam().getCustomParam().get("topBankMap");
        this.createTargetColumnGroup(cols, STAT, ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0\u5408\u8ba1", (String)"ReceiveDiscountDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), true);
        columns.addAll(cols);
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private ReportColumnGroup createReportColumnGroup(List<AbstractReportColumn> columns, String fieldKey, String caption) {
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setFieldKey(fieldKey);
        reportColumnGroup.setCaption(new LocaleString(caption));
        reportColumnGroup.setHideSingleColumnRow(true);
        columns.add((AbstractReportColumn)reportColumnGroup);
        return reportColumnGroup;
    }
}

