/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class AbstractDraftBillSecondSumFormListPlugin
extends AbstractReportFormPlugin {
    private static final String BANKRATE = "bankrate";
    private static final String FINKRATE = "finrate";
    private static final String BUSSRATE = "bussrate";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        queryParam.getFilter().addFilterItem("rptype", (Object)this.getRptType());
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        BigDecimal onehundred = new BigDecimal("100");
        for (DynamicObject row : rowData) {
            if (!StringUtils.isNotEmpty((String)row.getString("orgid"))) continue;
            BigDecimal bankrate = StringUtils.isEmpty((String)row.getString(BANKRATE)) ? BigDecimal.ZERO : row.getBigDecimal(BANKRATE);
            BigDecimal bankrateResult = bankrate.multiply(onehundred).setScale(2, RoundingMode.HALF_UP);
            row.set("bankratestr", (Object)(bankrateResult + " %"));
            BigDecimal finrate = StringUtils.isEmpty((String)row.getString(FINKRATE)) ? BigDecimal.ZERO : row.getBigDecimal(FINKRATE);
            BigDecimal finrateResult = finrate.multiply(onehundred).setScale(2, RoundingMode.HALF_UP);
            row.set("finratestr", (Object)(finrateResult + " %"));
            BigDecimal busskrate = StringUtils.isEmpty((String)row.getString(BUSSRATE)) ? BigDecimal.ZERO : row.getBigDecimal(BUSSRATE);
            BigDecimal bussrateResult = busskrate.multiply(onehundred).setScale(2, RoundingMode.HALF_UP);
            row.set("bussratestr", (Object)(bussrateResult + " %"));
        }
    }

    protected String getRptType() {
        return null;
    }
}

