/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.form;

import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class DraftBillAmtBankFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String RECEIVE_BILL = "receivebill";
    private static final String FILTER = "filter";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String GROUPNODEVALUE = "1";
    private static final String RPT_TYPE = "rptype";
    private static final String CLICK = "click";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        this.addItemClickListeners(new String[]{"toolbarap"});
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        queryParam.getFilter().addFilterItem(CLICK, customParams.get(CLICK));
        queryParam.getFilter().addFilterItem(RPT_TYPE, (Object)this.getRptType());
        return super.verifyQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_showdetail".equals(key)) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            this.transmitQueryParam(entity, formShowParameter, param);
            entity = entity + "_" + this.getRptType();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString(ISGROUPNODE);
        long orgId = row.getLong(ORGID);
        if (orgId == 0L || !GROUPNODEVALUE.equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgId));
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        String type = this.getRptType();
        param.getCustomParams().put(RPT_TYPE, type);
        String caption = this.getView().getFormShowParameter().getCaption();
        if (StringUtils.isNotEmpty((String)caption)) {
            param.setCaption(caption);
        }
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(this.getView().getFormShowParameter().getFormId());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        param.getCustomParams().put(CLICK, customParams.get(CLICK));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    private String getRptType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = RECEIVE_BILL;
        if (customParams.get(CLICK) != null) {
            type = ((String)customParams.get(CLICK)).split("_")[2];
        }
        return type;
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        String isGroupNode = rowData.getString(ISGROUPNODE);
        Object formatValue = evt.getFormatValue();
        if (formatValue != null && !GROUPNODEVALUE.equals(isGroupNode)) {
            evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
        }
    }

    private void transmitQueryParam(String entity, FormShowParameter formShowParameter, ReportShowParameter param) {
        if ("tda_draftbillamtbankrpt".equals(entity)) {
            String[] stringArray;
            String clickField = (String)formShowParameter.getCustomParam(CLICK);
            if (StringUtils.isNotEmpty((String)clickField)) {
                stringArray = StringUtils.split((String)clickField, (boolean)true, (char[])new char[]{'_'});
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "month";
                stringArray = stringArray2;
                stringArray2[1] = "41";
            }
            String[] fields = stringArray;
            param.getCustomParams().put("customtype", fields[0]);
            param.getCustomParams().put("datetype", fields[1]);
        }
    }
}

