/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.util.CollectionUtils;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BillCustRankHelper {
    private static final String DELIVERNAME = "delivername";
    private static final String DELIVERID = "deliver";
    private static final String PREFIX = "deliver_";
    private static final String ROWID = "rowid";
    private static final String ORGID = "orgid";
    private static final String AMOUNT = "amount";
    private static final String OHTERDELIVER_ID = "0";
    private static final String STAT = "bankcate_stat";

    public static Pair<DataSet, DataSet> splitTopDeliver(DataSet ds, String amount, int top) {
        HashSet<String> topDeliverSet = new HashSet<String>(16);
        DataSet topDeliverDataSet = ds.copy().filter("deliver > 0").select(new String[]{DELIVERID, DELIVERNAME, amount}).groupBy(new String[]{DELIVERID, DELIVERNAME}).sum(amount).finish().orderBy(new String[]{amount + " desc", DELIVERNAME}).top(top);
        while (topDeliverDataSet.hasNext()) {
            Row row = topDeliverDataSet.next();
            topDeliverSet.add(row.getLong(0).toString());
        }
        if (!topDeliverSet.isEmpty()) {
            String topFilter = "deliver in (" + String.join((CharSequence)",", topDeliverSet) + ")";
            DataSet[] splitTopDataSet = ds.splitByFilter(new String[]{topFilter}, true);
            if (splitTopDataSet != null && splitTopDataSet.length > 1) {
                return new Pair((Object)splitTopDataSet[0], (Object)splitTopDataSet[1]);
            }
            return new Pair((Object)ds, (Object)DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes()));
        }
        return new Pair((Object)ds, (Object)DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes()));
    }

    public static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    public static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("mixorgname orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add(ORGID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        return selectField;
    }

    public static DataSet groupby(DataSet groupDataSet, String[] groupStrs, List<String> sumFields) {
        GroupbyDataSet groupbyDataSet = groupDataSet.groupBy(groupStrs);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    public static List<AbstractReportColumn> getCols(DataSet totalSet, DataSet allData) {
        if (totalSet.isEmpty()) {
            return new ArrayList<AbstractReportColumn>();
        }
        Map<Long, String> deliverMap = BillCustRankHelper.getDeliverColKayAndNameMap(allData);
        Set<String> deliverCols = BillCustRankHelper.getDeliverCols(Arrays.asList(totalSet.getRowMeta().getFieldNames()), AMOUNT);
        ArrayList<AbstractReportColumn> datas = new ArrayList<AbstractReportColumn>();
        String otherDeliverCateColKey = BillCustRankHelper.getDeliverAmountColName(OHTERDELIVER_ID);
        if (CollectionUtils.isNotEmpty(deliverCols)) {
            Row totalRow = totalSet.next();
            ArrayList totalRowData = new ArrayList(32);
            deliverCols.forEach(r -> {
                BigDecimal bankCateAmount = totalRow.getBigDecimal(r);
                if (!otherDeliverCateColKey.equals(r)) {
                    totalRowData.add(new Pair(r, (Object)bankCateAmount));
                }
            });
            Collections.sort(totalRowData, (o1, o2) -> ((BigDecimal)o2.getValue1()).compareTo((BigDecimal)o1.getValue1()));
            for (Pair colNamePair : totalRowData) {
                String colKey = (String)colNamePair.getValue0();
                String substring = colKey.substring(PREFIX.length(), colKey.indexOf(AMOUNT));
                Long bankCateId = Long.valueOf(substring);
                datas.add(BillCustRankHelper.getReportCol(deliverMap.get(bankCateId), colKey));
            }
        }
        if (BillCustRankHelper.colExists(totalSet, OHTERDELIVER_ID)) {
            datas.add(BillCustRankHelper.getReportCol(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"BillBalanceCustRankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), BillCustRankHelper.getDeliverAmountColName(OHTERDELIVER_ID)));
        }
        return datas;
    }

    private static Map<Long, String> getDeliverColKayAndNameMap(DataSet allData) {
        HashMap<Long, String> deliverMap = new HashMap<Long, String>(32);
        if (!allData.isEmpty()) {
            while (allData.hasNext()) {
                Row row = allData.next();
                deliverMap.put(row.getLong(DELIVERID), row.getString(DELIVERNAME));
            }
        }
        return deliverMap;
    }

    private static Set<String> getDeliverCols(List<String> sumField, String suffix) {
        return sumField.stream().filter(f -> f.endsWith(suffix) && !BillCustRankHelper.getDeliverAmountColName(OHTERDELIVER_ID).equals(f)).collect(Collectors.toSet());
    }

    private static String getDeliverAmountColName(String deliverId) {
        return PREFIX + deliverId + AMOUNT;
    }

    private static AbstractReportColumn getReportCol(String catpion, String colKey) {
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(colKey);
        newCol.setFieldType("decimal");
        newCol.setZeroShow(true);
        newCol.setScale(2);
        newCol.setCaption(new LocaleString(catpion));
        newCol.setStyle(columnStyle);
        ReportColumn result = newCol;
        return result;
    }

    private static boolean colExists(DataSet dataSet, String deliverId) {
        return dataSet.getRowMeta().getFieldIndex(PREFIX + deliverId + AMOUNT, false) != -1;
    }

    public static List<AbstractReportColumn> getBillCustRankColumns(List<AbstractReportColumn> columns, List<AbstractReportColumn> cols) {
        columns.addAll(cols);
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(STAT);
        newCol.setFieldType("decimal");
        newCol.setZeroShow(true);
        newCol.setScale(2);
        newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BillBalanceCustRankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)newCol);
        return columns;
    }
}

