/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class DraftBillSpreadHelper {
    private static final String BILLTYPE = "billtype";
    private static final String DATERANGE = "dateRange";
    private static final String DATERANGENUM = "dateRangeNum";
    private static final Map<String, String> monthMap = new LinkedHashMap<String, String>(10){
        {
            this.put("onemonth", ResManager.loadKDString((String)"1\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("twomonth", ResManager.loadKDString((String)"2\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("threemonth", ResManager.loadKDString((String)"3\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("sixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u5230\u671f", (String)"BillSpreadDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]));
            this.put("oversixmonth", ResManager.loadKDString((String)"6\u4e2a\u6708\u4ee5\u4e0a\u5230\u671f", (String)"BillSpreadDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
    };

    public static DataSet getDataSetByBillType(String className, Long basecurrency, Map<String, Object> paramMap) {
        String bankAcceptAnce = ResManager.loadKDString((String)"\u94f6\u884c\u627f\u5151", (String)"DraftBillSpreadHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        String businessAcceptAnce = ResManager.loadKDString((String)"\u5546\u4e1a\u627f\u5151", (String)"DraftBillSpreadHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]);
        String financeAcceptAnce = ResManager.loadKDString((String)"\u8d22\u53f8\u627f\u5151", (String)"DraftBillSpreadHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]);
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String rptype = (String)paramMap.get("rptype");
        DataSet allDs = DraftBillDataHelper.getBillBalanceDataSet((String)className, (List)allorgids, (Date)queryDate, (Long)basecurrency, (Long)orgviewId, (String)rptype).filter("billType in billTypes", Collections.singletonMap("billTypes", Arrays.asList("5", "6", "20"))).addFields(new String[]{"' '", "' '"}, new String[]{DATERANGE, DATERANGENUM}).select("billType,dateRange,dateRangeNum,amount,expiredate");
        DataSet union = DraftBillSpreadHelper.getDataSetByCurrentDate(allDs, queryDate, new ArrayList<String>(monthMap.values()), new ArrayList<String>(monthMap.keySet()));
        union = DraftBillSpreadHelper.addZeroDataRangeField(union.groupBy(new String[]{"billType", DATERANGE, DATERANGENUM, "expiredate"}).sum("amount").finish());
        String selectStr = "amount,case when billType = '5' then '%1$s' when  billType = '6' then '%2$s' else '%3$s' end as billtype,case when billType = '5' then '3' when  billType = '6' then '1' else '2' end as billTypeSort,dateRange";
        selectStr = String.format(selectStr, businessAcceptAnce, bankAcceptAnce, financeAcceptAnce);
        union = union.select(selectStr).groupBy(new String[]{BILLTYPE, DATERANGE, "billTypeSort"}).sum("amount").finish();
        return union;
    }

    private static DataSet addZeroDataRangeField(DataSet allDataSet) {
        Pair<List<String>, List<String>> billTypeAndDataRanges = DraftBillSpreadHelper.getBillTypeAndDataRanges(allDataSet);
        boolean containOverSixMonth = true;
        if (!((List)billTypeAndDataRanges.getValue1()).contains("oversixmonth")) {
            containOverSixMonth = false;
        }
        List<String> allBillTypeAndDateRanges = DraftBillSpreadHelper.getAllBillTypeAndDateRange(new ArrayList<String>(monthMap.keySet()), (List)billTypeAndDataRanges.getValue0(), containOverSixMonth);
        allDataSet = allDataSet.addField("concat(billType, '_' , dateRangeNum)", "billTypeAndDateRange");
        DataSet copy = allDataSet.copy().groupBy(new String[]{"billTypeAndDateRange"}).finish();
        ArrayList<String> containDataList = new ArrayList<String>(16);
        while (copy.hasNext()) {
            Row row = copy.next();
            String billTypeAndDateRange = row.getString("billTypeAndDateRange");
            containDataList.add(billTypeAndDateRange);
        }
        allBillTypeAndDateRanges.removeAll(containDataList);
        RowMeta rowMeta = allDataSet.getRowMeta();
        Date addDate = new Date();
        for (String allBillTypeAndDateRange : allBillTypeAndDateRanges) {
            String billType = allBillTypeAndDateRange.substring(0, allBillTypeAndDateRange.indexOf("_"));
            String dateRangeNum = allBillTypeAndDateRange.substring(allBillTypeAndDateRange.indexOf("_") + 1);
            allDataSet = allDataSet.union(DecisionAnlsHelper.createRow(DraftBillSpreadHelper.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{billType, monthMap.get(dateRangeNum), dateRangeNum, addDate, "0", allBillTypeAndDateRange})));
        }
        return allDataSet;
    }

    private static List<String> getAllBillTypeAndDateRange(List<String> monthList, List<String> dateRangeList, boolean containOverSixMonth) {
        ArrayList<String> resultList = new ArrayList<String>(16);
        for (String dateRange : dateRangeList) {
            for (String month : monthList) {
                if (!containOverSixMonth && "oversixmonth".equals(month)) continue;
                resultList.add(dateRange + "_" + month);
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<List<String>, List<String>> getBillTypeAndDataRanges(DataSet ds) {
        ArrayList<String> financeTypes = new ArrayList<String>(4);
        ArrayList<String> dateRangeNumTypes = new ArrayList<String>(6);
        try (DataSet copy = null;){
            copy = ds.copy().groupBy(new String[]{BILLTYPE, DATERANGENUM}).finish();
            while (copy.hasNext()) {
                Row row = copy.next();
                String financeType = row.getString(BILLTYPE);
                String dateRangeNumType = row.getString(DATERANGENUM);
                if (financeType != null && !financeTypes.contains(financeType)) {
                    financeTypes.add(financeType);
                }
                if (dateRangeNumType == null || dateRangeNumTypes.contains(dateRangeNumType)) continue;
                dateRangeNumTypes.add(dateRangeNumType);
            }
            Pair pair = new Pair(financeTypes, dateRangeNumTypes);
            return pair;
        }
    }

    public static DataSet getDataSetByCurrentDate(DataSet allData, final Date queryDate, final List<String> monthList, final List<String> monthListNumber) {
        final Date oneMonthDate = DateUtils.getAfterMonthAccordThirtyDays((Date)queryDate, (int)1);
        final Date twoMonthDate = DateUtils.getAfterMonthAccordThirtyDays((Date)queryDate, (int)2);
        final Date threeMonthDate = DateUtils.getAfterMonthAccordThirtyDays((Date)queryDate, (int)3);
        final Date sixMonthDate = DateUtils.getAfterMonthAccordThirtyDays((Date)queryDate, (int)6);
        final RowMeta rowMeta = allData.getRowMeta();
        allData = allData.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(20);
                for (String fieldName : rowMeta.getFieldNames()) {
                    Date expiredate = row.getDate("expiredate");
                    if (DraftBillSpreadHelper.DATERANGE.equals(fieldName)) {
                        if (expiredate.compareTo(queryDate) > 0 && expiredate.compareTo(oneMonthDate) <= 0) {
                            rowInfo.add(monthList.get(0));
                            continue;
                        }
                        if (expiredate.compareTo(oneMonthDate) > 0 && expiredate.compareTo(twoMonthDate) <= 0) {
                            rowInfo.add(monthList.get(1));
                            continue;
                        }
                        if (expiredate.compareTo(twoMonthDate) > 0 && expiredate.compareTo(threeMonthDate) <= 0) {
                            rowInfo.add(monthList.get(2));
                            continue;
                        }
                        if (expiredate.compareTo(threeMonthDate) > 0 && expiredate.compareTo(sixMonthDate) <= 0) {
                            rowInfo.add(monthList.get(3));
                            continue;
                        }
                        if (expiredate.compareTo(sixMonthDate) <= 0) continue;
                        rowInfo.add(monthList.get(4));
                        continue;
                    }
                    if (DraftBillSpreadHelper.DATERANGENUM.equals(fieldName)) {
                        if (expiredate.compareTo(queryDate) > 0 && expiredate.compareTo(oneMonthDate) <= 0) {
                            rowInfo.add(monthListNumber.get(0));
                            continue;
                        }
                        if (expiredate.compareTo(oneMonthDate) > 0 && expiredate.compareTo(twoMonthDate) <= 0) {
                            rowInfo.add(monthListNumber.get(1));
                            continue;
                        }
                        if (expiredate.compareTo(twoMonthDate) > 0 && expiredate.compareTo(threeMonthDate) <= 0) {
                            rowInfo.add(monthListNumber.get(2));
                            continue;
                        }
                        if (expiredate.compareTo(threeMonthDate) > 0 && expiredate.compareTo(sixMonthDate) <= 0) {
                            rowInfo.add(monthListNumber.get(3));
                            continue;
                        }
                        if (expiredate.compareTo(sixMonthDate) <= 0) continue;
                        rowInfo.add(monthListNumber.get(4));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return allData;
    }
}

