/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.note.helper.DraftBillAmountHelper;

public abstract class AbstractBillAmountCustRankQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String BILLTYPE = "billtype";
    private static final String BILLTYPESORT = "billtypesort";
    private static final String BILLTYPENAME = "billtypename";
    private static final String DELIVERNAME = "delivername";
    private static final String RECEIVERNAME = "receivername";
    private static final String CUSTORSUPNAME = "custorsupname";
    public static final String RECEIVEBILL = "receivebill";
    public static final String DISPLAYTYPE = "displayType";
    public static final String RPTYPE = "rptype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BILLTYPE, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"AbstractBillAmountCustRankQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{BILLTYPENAME, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b\u540d\u79f0", (String)"AbstractBillAmountCustRankQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{CUSTORSUPNAME, ResManager.loadKDString((String)"\u5ba2\u6237\u6216\u4f9b\u5e94\u5546\u540d\u79f0", (String)"AbstractBillAmountCustRankQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u4f59\u989d", (String)"AbstractBillAmountCustRankQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{BILLTYPESORT, ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b\u6392\u5e8f", (String)"AbstractBillAmountCustRankQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String rptype = this.getRpType();
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet allDs = DraftBillDataHelper.getBillAccruedDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId, (String)rptype).filter("billtype in ('5', '6', '20')").select(new String[]{BILLTYPE, AMOUNT, DELIVERNAME, RECEIVERNAME, RPTYPE, "registereddate", "issuedate"});
        allDs = RECEIVEBILL.equals(rptype) ? allDs.addField(DELIVERNAME, CUSTORSUPNAME) : allDs.addField(RECEIVERNAME, CUSTORSUPNAME);
        DataSet termData = DraftBillAmountHelper.getTermData(allDs, queryDate, rptype, null, null);
        String billtypeStr = "case when billtype = '5' then %1$s when billtype = '20' then %2$s when billtype = '6' then %3$s else %4$s end";
        termData = termData.addField(String.format(billtypeStr, ResManager.loadKDString((String)"'\u5546\u4e1a\u627f\u5151'", (String)"AbstractBillBalanceCustRankQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u8d22\u53f8\u627f\u5151'", (String)"AbstractBillBalanceCustRankQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u94f6\u884c\u627f\u5151'", (String)"AbstractBillBalanceCustRankQingDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"'\u5176\u4ed6'", (String)"AbstractBillBalanceCustRankQingDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0])), BILLTYPENAME);
        return termData.groupBy(new String[]{BILLTYPE, BILLTYPENAME, CUSTORSUPNAME, "customtype", "term"}).sum(AMOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)"termtype", (String)"term");
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)termType) && EmptyUtil.isNoEmpty((String)term)) {
            String filter = "customtype  = '" + termType + "' and " + "term" + " = '" + term + "'";
            ds = ds.filter(filter);
        }
        DataSet[] dataSets = ds.splitByFilter(new String[]{"true", "true"}, false);
        DataSet allDataSet = dataSets[1].groupBy(new String[]{CUSTORSUPNAME}).sum(AMOUNT).finish().addFields(new String[]{"'all'", ResManager.loadKDString((String)"'\u5168\u90e8'", (String)"AbstractBillBalanceCustRankQingDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0])}, new String[]{BILLTYPE, BILLTYPENAME}).select(new String[]{BILLTYPE, BILLTYPENAME, CUSTORSUPNAME, AMOUNT});
        DataSet result = dataSets[0].select(allDataSet.getRowMeta().getFieldNames()).union(allDataSet);
        result = result.addField("case when billtype = '5' then '1' when billtype = '20' then '2' when billtype = '6' then '3' else '0' end", BILLTYPESORT);
        return result.orderBy(new String[]{BILLTYPESORT});
    }

    protected abstract String getRpType();

    protected abstract String getLinkRptFormId();

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(this.getLinkRptFormId());
        String rpType = this.getRpType();
        String caption = RECEIVEBILL.equals(rpType) ? ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u6536\u7968\u5ba2\u6237\u6392\u540d-\u53d1\u751f\u989d\u8868", (String)"AbstractBillAmountCustRankQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5f00\u7968\u4f9b\u5e94\u5546\u6392\u540d-\u53d1\u751f\u989d\u8868", (String)"AbstractBillAmountCustRankQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
        parameter.setCaption(caption);
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), null, (String)"termtype", (String)"term");
        String termType = (String)typeLinkValue.getValue0();
        String term = (String)typeLinkValue.getValue1();
        parameter.getCustomParams().put("termtype", termType);
        parameter.getCustomParams().put("term", term);
        parameter.getCustomParams().put(DISPLAYTYPE, ids.get(0));
        parameter.getCustomParams().put(RPTYPE, rpType);
        parameter.getCustomParams().put("caption", caption);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId(this.getLinkRptFormId());
        String rpType = this.getRpType();
        String caption = RECEIVEBILL.equals(rpType) ? ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u6536\u7968\u5ba2\u6237\u6392\u540d-\u53d1\u751f\u989d\u8868", (String)"AbstractBillAmountCustRankQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u5f00\u7968\u4f9b\u5e94\u5546\u6392\u540d-\u53d1\u751f\u989d\u8868", (String)"AbstractBillAmountCustRankQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.setCaption(caption);
        Map customParams = param.getCustomParams();
        customParams.put("termtype", paramMap.get("customtype"));
        customParams.put("term", paramMap.get("term"));
        customParams.put(RPTYPE, rpType);
        customParams.put("caption", caption);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BILLTYPE;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkRptFormId());
    }
}

