/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.note.qing;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.DraftBillDataHelper;
import kd.tmc.tda.report.common.data.AbstractRankAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractDraftBillAccepterBankPlugin
extends AbstractRankAnlsQingDataPlugin {
    private static final String RECEIVE_BILL = "receivebill";
    private static final int TOP_NUMBER = 10;
    private static final String ACCEPTER_BANKCATE_NAME = "accepterbankcatename";
    private static final String AMOUNT = "amount";

    @Override
    protected int topNum() {
        return 10;
    }

    @Override
    protected String rankTypeField() {
        return ACCEPTER_BANKCATE_NAME;
    }

    @Override
    protected String rankSumField() {
        return AMOUNT;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected String otherRowName() {
        return ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"ReceiveBillDiscountBankQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private List<Pair<String, String>> getSplitFilter() {
        return Arrays.asList(new Pair((Object)"billtype = '6'", (Object)""), new Pair((Object)"billtype = '20'", (Object)ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])), new Pair((Object)"billtype = '5'", (Object)ResManager.loadKDString((String)"'\u5546\u4e1a\u7968\u636e'", (String)"ReceiveBillDiscountBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])));
    }

    @Override
    protected DataSet[] getDetailData(Map<String, Object> paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet detaiData = DraftBillDataHelper.getBillBalanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgviewId, (String)this.getRpType()).select("accepterbankcatename,amount,billtype");
        return this.getSplitDataSet(detaiData, this.getSplitFilter());
    }

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{ACCEPTER_BANKCATE_NAME, ResManager.loadKDString((String)"\u627f\u5151\u884c", (String)"AbstractDraftBillAccepterBankPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractDraftBillAccepterBankPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"AbstractDraftBillAccepterBankPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected abstract String getRpType();

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_draftbill_accprpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ACCEPTER_BANKCATE_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put("rptype", this.getRpType());
        param.setFormId("tda_draftbill_accprpt");
        if (RECEIVE_BILL.equals(this.getRpType())) {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u627f\u5151\u673a\u6784\u4f59\u989d\u5206\u5e03\u8868", (String)"AbstractDraftBillAccepterBankPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u627f\u5151\u673a\u6784\u4f59\u989d\u5206\u5e03\u8868", (String)"AbstractDraftBillAccepterBankPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put("rptype", this.getRpType());
        param.setFormId("tda_draftbill_accprpt");
        if (RECEIVE_BILL.equals(this.getRpType())) {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u627f\u5151\u673a\u6784\u4f59\u989d\u5206\u5e03\u8868", (String)"AbstractDraftBillAccepterBankPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        } else {
            param.setCaption(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u627f\u5151\u673a\u6784\u4f59\u989d\u5206\u5e03\u8868", (String)"AbstractDraftBillAccepterBankPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
    }
}

