/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.helper.BigAmountFlowDetailHelper;

public abstract class AbstractBigAmountFlowDetailDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final String InFlow = "InFlow";
    protected static final String OutFlow = "OutFlow";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long currencyId = ((DynamicObject)paramMap.get("currency")).getLong("id");
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        HashMap dateParamsMap = new HashMap(2);
        String dateRange = (String)paramMap.get("dateRange");
        String filterDateStr = SettleDataHelper.getFilterDateStr((Date)queryDate, (String)dateRange, dateParamsMap);
        DataSet dataSet = SettleDataHelper.queryBigAmtSet((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (List)((List)paramMap.get("allorgids")), (Date)queryDate).filter(filterDateStr, dateParamsMap).filter(this.getFilter()).select(this.getSelectInfo());
        String regionExpr = String.format("case region when 'domestic' then '%1$s' when 'overseas' then '%2$s' end", ResManager.loadKDString((String)"\u5883\u5185", (String)"AbstractBigAmountFlowDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5916", (String)"AbstractBigAmountFlowDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        String fundFlowExpr = String.format("case moneyflow when 'in_flow' then '%1$s' when 'out_flow' then '%2$s' end", ResManager.loadKDString((String)"\u6d41\u5165", (String)"AbstractBigAmountFlowDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d41\u51fa", (String)"AbstractBigAmountFlowDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        dataSet = dataSet.updateFields(new String[]{"region", "moneyflow"}, new String[]{regionExpr, fundFlowExpr});
        DynamicObject bigAmountSet = BusinessDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountgetterway", (QFilter[])new QFilter[0]);
        String sourceType = bigAmountSet.getString("bigamountgetterway");
        dataSet = dataSet.addField("case entityname when 'cas_paybill' then '0' when 'cas_recbill' then '0' when 'bei_transdetail' then '1' end", "sourcetype");
        dataSet = dataSet.filter("sourcetype = source", Collections.singletonMap("source", sourceType));
        dataSet = BigAmountFlowDetailHelper.getSecondOrgDs(orgViewId, currentOrgId, dataSet);
        Set<String> amountFields = Collections.singleton("reportamount");
        dataSet = AmountTransHelper.tranDataSetRate((DataSet)dataSet, (Long)orgViewId, (Long)baseCurrencyId, (String)"currency", amountFields, (Date)queryDate);
        dataSet = dataSet.addFields(new String[]{String.valueOf(currencyId), "currency"}, new String[]{"listcurrency", "initcurrency"});
        DataSet totalSet = this.addAllTotalDataSet(dataSet, Collections.singletonList("reportamount"), Collections.singletonList("listcurrency"), "orgname");
        DataSet resultSet = dataSet.union(totalSet);
        resultSet = AmountTransHelper.dealAmountConvert((DataSet)resultSet, (Map)paramMap, amountFields);
        HashSet<String> amountUnitSet = new HashSet<String>(Arrays.asList(OutFlow.equals(this.getRptType()) ? "debitamount" : "creditamount", "reportamount"));
        resultSet = AmountTransHelper.dealAmountUnit((DataSet)resultSet, (Map)paramMap, amountUnitSet);
        return resultSet;
    }

    protected abstract String getFilter();

    protected abstract String getSelectInfo();

    protected String getRptType() {
        return "";
    }
}

