/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.helper.BigAmountFlowDetailHelper;

public class BigAmtInOutFlowAnlsDetailPlugin
extends AbstractDetailDataPlugin {
    private static final String LONG_NUMBER = "longnumber";
    private Long orgViewId;

    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"BigAmtInOutFlowAnlsDetailPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"secondorg", ResManager.loadKDString((String)"\u6240\u5c5e\u4f01\u4e1a", (String)"BigAmtInOutFlowAnlsDetailPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"oppname", ResManager.loadKDString((String)"\u4ea4\u6613\u5bf9\u624b", (String)"BigAmtInOutFlowAnlsDetailPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"region", ResManager.loadKDString((String)"\u533a\u57df", (String)"BigAmtInOutFlowAnlsDetailPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BigAmtInOutFlowAnlsDetailPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"tradecnt", ResManager.loadKDString((String)"\u4ea4\u6613\u7b14\u6570", (String)"BigAmtInOutFlowAnlsDetailPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"tradeamt", ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"BigAmtInOutFlowAnlsDetailPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"reportamount", ResManager.loadKDString((String)"\u6298\u672c\u4f4d\u5e01", (String)"BigAmtInOutFlowAnlsDetailPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"BigAmtInOutFlowAnlsDetailPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"usage", ResManager.loadKDString((String)"\u4ea4\u6613\u7528\u9014", (String)"BigAmtInOutFlowAnlsDetailPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"moneyflow", ResManager.loadKDString((String)"\u6d41\u5165\u6d41\u51fa\u6807\u8bc6", (String)"BigAmtInOutFlowAnlsDetailPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BigAmtInOutFlowAnlsDetailPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        this.orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        String dateRange = (String)paramMap.get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = "six_month";
        }
        HashMap dateParamsMap = new HashMap(2);
        String filterDateStr = SettleDataHelper.getFilterDateStr((Date)queryDate, (String)dateRange, dateParamsMap);
        String selectField = "billno,orgname, orgname as secondorg,orgid,orgid as company,oppname,region,currency,currencyname,creditamount,debitamount,moneyflow,bizdate,usage,'' as dateRange,entityname";
        DataSet allDs = SettleDataHelper.queryBigAmtSet((String)((Object)((Object)this)).getClass().getName(), (Long)this.orgViewId, (List)orgIds, (Date)queryDate).filter(filterDateStr, dateParamsMap).select(selectField);
        DynamicObject bigAmountSet = BusinessDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountgetterway", (QFilter[])new QFilter[0]);
        String sourceType = bigAmountSet.getString("bigamountgetterway");
        allDs = allDs.addField("case entityname when 'cas_paybill' then '0' when 'cas_recbill' then '0' when 'bei_transdetail' then '1' end", "sourcetype");
        allDs = allDs.filter("sourcetype = source", Collections.singletonMap("source", sourceType));
        DataSet[] flowNumSets = allDs.splitByFilter(new String[]{"moneyflow = 'in_flow'", "moneyflow = 'out_flow'"}, false);
        flowNumSets[0] = flowNumSets[0].addFields(new String[]{"creditamount", "creditamount", "1"}, new String[]{"reportamount", "tradeamt", "tradecnt"});
        flowNumSets[1] = flowNumSets[1].addFields(new String[]{"debitamount", "debitamount", "1"}, new String[]{"reportamount", "tradeamt", "tradecnt"});
        DataSet resultSet = flowNumSets[0].union(flowNumSets[1]);
        resultSet = BigAmountFlowDetailHelper.getSecondOrgDs(this.orgViewId, currentOrgId, resultSet);
        Set<String> amountFields = Collections.singleton("reportamount");
        resultSet = AmountTransHelper.tranDataSetRate((DataSet)resultSet, (Long)this.orgViewId, (Long)baseCurrencyId, (String)"currency", amountFields, (Date)queryDate);
        String regionExpr = String.format("case region when 'domestic' then '%1$s' when 'overseas' then '%2$s' end", ResManager.loadKDString((String)"\u5883\u5185", (String)"AbstractBigAmountFlowDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5916", (String)"AbstractBigAmountFlowDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        String fundFlowExpr = String.format("case moneyflow when 'in_flow' then '%1$s' when 'out_flow' then '%2$s' end", ResManager.loadKDString((String)"\u6d41\u5165", (String)"AbstractBigAmountFlowDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d41\u51fa", (String)"AbstractBigAmountFlowDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        resultSet = resultSet.updateFields(new String[]{"region", "moneyflow"}, new String[]{regionExpr, fundFlowExpr});
        return resultSet;
    }

    @Override
    protected DataSet beforeReturn(DataSet result) {
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)this.orgViewId);
        result = result.removeFields(new String[]{"mixorgname"});
        String[] rf = result.getRowMeta().getFieldNames();
        result = result.leftJoin(orgDateSet).on("rowid", "orgid").select(rf, new String[]{"mixorgname"}).finish();
        List<String> rfList = Stream.of(result.getRowMeta().getFieldNames()).collect(Collectors.toList());
        Collections.replaceAll(rfList, "orgname", "case when mixorgname != null then mixorgname else orgname end as orgname");
        result = result.select(rfList.toArray(new String[0]));
        return result;
    }

    @Override
    protected String getCountField() {
        return "tradecnt";
    }

    @Override
    protected List<String> getSumLists() {
        return Collections.singletonList("reportamount");
    }

    @Override
    protected Set<String> getCovertList() {
        return new HashSet<String>(Collections.singletonList("reportamount"));
    }
}

