/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundFlowTrendDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private String SEPARATOR_COMMA = ",";
    private String ORG = "org";
    private String ORG_NAME = "orgname";
    private String MONTH_DATE = "monthdate";
    private Date starDate = null;
    private Date endDate = null;
    private int dateOffset = 12;
    private String COMPANY = "org";
    private String CURRENCY = "currency";
    private String CREDIT_AMOUNT = "creditamount";
    private String DEBIT_AMOUNT = "debitamount";
    private String NET_INFLOW = "net_inflow";

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map reportQueryMap = this.transQueryParam(reportQueryParam);
        Long orgViewId = ((DynamicObject)reportQueryMap.get("orgview")).getLong("id");
        Long baseCurrencyId = (Long)reportQueryMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(reportQueryMap);
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String dateFilterStr = this.getDateFilterStr(reportQueryMap, dateMap);
        DataSet transDetailDataSet = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, (List)((List)reportQueryMap.get("allorgids")), (Date)queryDate).filter(dateFilterStr, dateMap).select(new String[]{this.COMPANY, this.MONTH_DATE, this.CURRENCY, this.CREDIT_AMOUNT, this.DEBIT_AMOUNT});
        return transDetailDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        RowMeta rowMeta = ds.getRowMeta();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        ds = ds.addField("replace(substr(monthdate,0,7),'-','')", "date_type");
        DataSet transDetailGroupByDataSet = ds.groupBy(new String[]{this.ORG, "date_type"}).sum(this.CREDIT_AMOUNT).sum(this.DEBIT_AMOUNT).finish();
        DataSet creditAmountSet = transDetailGroupByDataSet.copy().addField("case when true then creditamount end", "count");
        creditAmountSet = DecisionAnlsHelper.ChangeRowToColDataSet(creditAmountSet, "date_type", this.ORG, this.CREDIT_AMOUNT + "_");
        DataSet debitAmountSet = transDetailGroupByDataSet.addField("case when true then debitamount end", "count");
        debitAmountSet = DecisionAnlsHelper.ChangeRowToColDataSet(debitAmountSet, "date_type", this.ORG, this.DEBIT_AMOUNT + "_");
        DataSet transDataSet = this.mergeDS(creditAmountSet, debitAmountSet, new String[]{this.ORG}, new String[]{this.ORG});
        transDataSet = this.mergeDS(orgDateSet, transDataSet, new String[]{this.ORG}, new String[]{this.ORG}).removeFields(new String[]{this.ORG_NAME});
        transDataSet = this.addNetInflowFields(transDataSet, paramMap).addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(transDataSet, this.getSumFieldNames(transDataSet), this.ORG + this.SEPARATOR_COMMA + "mixorgname,sortcode");
        DataSet filterDataSet = sumDataSet.addField("case when true then mixorgname end", this.ORG_NAME);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("org in ids", Collections.singletonMap("ids", subOrgIds));
        }
        List<String> sumFieldNames = this.getSumFieldNames(filterDataSet);
        filterDataSet = this.removeAllZeroRow(filterDataSet, new HashSet<String>(sumFieldNames));
        DataSet totalDataSet = this.addAllTotalDataSet(filterDataSet, sumFieldNames, this.ORG_NAME);
        filterDataSet = filterDataSet.orderBy(new String[]{"sortcode"});
        DataSet resultSet = filterDataSet.union(totalDataSet);
        resultSet = AmountTransHelper.dealRowOtherValue((DataSet)resultSet, (Map)paramMap, new HashSet<String>(sumFieldNames));
        return resultSet;
    }

    private DataSet mergeDS(DataSet ds1, DataSet ds2, String[] leftJoinFieldName, String[] rightJoinFieldName) {
        ArrayList<String> fieldNameList = new ArrayList<String>(16);
        Collections.addAll(fieldNameList, ds1.getRowMeta().getFieldNames());
        for (String fieldName : ds2.getRowMeta().getFieldNames()) {
            if (fieldNameList.contains(fieldName)) continue;
            fieldNameList.add(fieldName);
        }
        JoinDataSet ds = ds1.join(ds2, JoinType.LEFT);
        for (int index = 0; index < rightJoinFieldName.length; ++index) {
            ds.on(leftJoinFieldName[index].trim(), rightJoinFieldName[index].trim());
        }
        return ds.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
    }

    private List<String> getSumFieldNames(DataSet dataSet) {
        String[] fieldNames;
        ArrayList<String> sumFieldNames = new ArrayList<String>();
        for (String fieldName : fieldNames = dataSet.getRowMeta().getFieldNames()) {
            if (!Pattern.matches(".*\\d$", fieldName)) continue;
            sumFieldNames.add(fieldName);
        }
        return sumFieldNames;
    }

    private DataSet addNetInflowFields(DataSet transDataSet, Map<String, Object> paramMap) {
        HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(transDataSet.getRowMeta().getFieldNames()));
        this.initDate(paramMap);
        for (int i = 0; i < this.dateOffset; ++i) {
            Date dateGroup = DateUtils.getFirstDateOfAnyMonth((Date)this.starDate, (int)i);
            String dateGroupStr = DateUtils.formatString((Date)dateGroup, (String)"yyyyMM");
            String creditKey = this.CREDIT_AMOUNT + "_" + dateGroupStr;
            String debitKey = this.DEBIT_AMOUNT + "_" + dateGroupStr;
            if (!fieldNames.contains(creditKey)) {
                transDataSet = transDataSet.addField("0", creditKey);
            }
            if (!fieldNames.contains(debitKey)) {
                transDataSet = transDataSet.addField("0", debitKey);
            }
            transDataSet = transDataSet.addField(creditKey + "-" + debitKey, this.NET_INFLOW + "_" + i);
        }
        return transDataSet;
    }

    private String getDateFilterStr(Map<String, Object> reportQueryMap, Map<String, Object> dateMap) {
        this.initDate(reportQueryMap);
        dateMap.put("starDate", this.starDate);
        dateMap.put("endDate", this.endDate);
        String dateFilterStr = this.MONTH_DATE + ">=" + "starDate and " + this.MONTH_DATE + "<=" + "endDate";
        return dateFilterStr;
    }

    private void initDate(Map<String, Object> reportQueryMap) {
        Date currentDate = DecisionAnlsHelper.getQueryDate(reportQueryMap);
        this.starDate = DateUtils.getFirstDateOfAnyMonth((Date)currentDate, (int)(-this.dateOffset));
        this.endDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        for (int i = this.dateOffset - 1; i >= 0; --i) {
            Date dateGroup = DateUtils.getFirstDateOfAnyMonth((Date)this.starDate, (int)i);
            String dateGroupStr = DateUtils.formatString((Date)dateGroup, (String)"yyyyMM");
            String creditKey = this.CREDIT_AMOUNT + "_" + dateGroupStr;
            String debitKey = this.DEBIT_AMOUNT + "_" + dateGroupStr;
            String netInflowKey = this.NET_INFLOW + "_" + i;
            ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
            reportColumnGroup.setFieldKey(dateGroupStr);
            reportColumnGroup.setCaption(new LocaleString(DateUtils.getYear((Date)dateGroup) + new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"FundFlowTrendDataPulgin_8", (String)"tmc-tda-report", (Object[])new Object[0])).toString() + DateUtils.getMonth((Date)dateGroup) + new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"FundFlowTrendDataPulgin_9", (String)"tmc-tda-report", (Object[])new Object[0]))));
            reportColumnGroup.getChildren().add(this.createColumn(creditKey, ResManager.loadKDString((String)"\u6d41\u5165", (String)"FundFlowTrendDataPulgin_6", (String)"tmc-tda-report", (Object[])new Object[0])));
            reportColumnGroup.getChildren().add(this.createColumn(debitKey, ResManager.loadKDString((String)"\u6d41\u51fa", (String)"FundFlowTrendDataPulgin_7", (String)"tmc-tda-report", (Object[])new Object[0])));
            reportColumnGroup.getChildren().add(this.createColumn(netInflowKey, ResManager.loadKDString((String)"\u51c0\u6d41\u5165", (String)"FundFlowTrendDataPulgin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
            columns.add((AbstractReportColumn)reportColumnGroup);
        }
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setScale(2);
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        return reportColumn;
    }
}

