/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.common.SettleMgHelper;

public class SettleCountFlowDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(SettleCountFlowDataListPlugin.class);
    private List<String> COUNT_FIELDS = Arrays.asList("intflow_currday", "intflow_currmonth", "intflow_curryear", "outflow_currday", "outflow_currmonth", "outflow_curryear");

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String currDaySic = "company, case when creditamount <> 0 and debitamount = 0 then 1 else 0 end as intflow_currday, case when creditamount = 0 and debitamount <> 0 then 1 else 0 end as outflow_currday,0 as intflow_currmonth, 0 as outflow_currmonth, 0 as intflow_curryear, 0 as outflow_curryear, areaRange";
        DataSet currDayDs = SettleDataHelper.queryTransDetail((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, (Date)queryDate, (List)((List)paramMap.get("allorgids")), (String)"queryCurrDayAmt").filter("(creditamount <> 0 and debitamount = 0) or (debitamount <> 0 and creditamount = 0)").select(currDaySic);
        DataSet currDayCountDs = currDayDs.groupBy(new String[]{"company", "areaRange"}).sum("intflow_currday").sum("outflow_currday").finish();
        currDayCountDs = currDayCountDs.addFields(new String[]{"0", "0", "0", "0"}, new String[]{"intflow_currmonth", "outflow_currmonth", "intflow_curryear", "outflow_curryear"});
        String currMonthSic = "org as company, areaRange, 0 as intflow_currday, 0 as outflow_currday, creditcount as intflow_currmonth, debitcount as outflow_currmonth, 0 as intflow_curryear, 0 as outflow_curryear";
        DataSet transDetails = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, (List)((List)paramMap.get("allorgids")), (Date)queryDate);
        DataSet currMonthDs = transDetails.copy().filter(SettleMgHelper.getDateFilterStr("currmonth", queryDate, dateMap), dateMap).select(currMonthSic);
        DataSet currYearDs = transDetails.filter(SettleMgHelper.getDateFilterStr("curryear", queryDate, dateMap), dateMap).select(currMonthSic);
        DataSet currYearGroupDs = currYearDs.groupBy(new String[]{"company", "areaRange"}).sum("intflow_currmonth", "intflow_curryear").sum("outflow_currmonth", "outflow_curryear").finish();
        currYearGroupDs = currYearGroupDs.select("company, areaRange, 0 as intflow_currday, 0 as outflow_currday,0 as intflow_currmonth, 0 as outflow_currmonth, intflow_curryear, outflow_curryear");
        DataSet allSet = currDayCountDs.union(currMonthDs).union(currYearGroupDs);
        return allSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String type = SettleMgHelper.getAreaRange(paramMap);
        logger.info("SettleCountFlowDataListPlugin filterResultDataSet areaRange: " + type);
        if (!"all".equals(type)) {
            ds = ds.filter("areaRange = '" + type + "'");
        }
        ds = ds.groupBy(new String[]{"company"}).sum(this.COUNT_FIELDS.get(0)).sum(this.COUNT_FIELDS.get(1)).sum(this.COUNT_FIELDS.get(2)).sum(this.COUNT_FIELDS.get(3)).sum(this.COUNT_FIELDS.get(4)).sum(this.COUNT_FIELDS.get(5)).finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDs = orgDateSet.leftJoin(ds).on("org", "company").select(new String[]{"org", "orgid", "rowid", "pid", "isgroupnode", "level", "mixorgname org_name", "sortcode", "intflow_currday", "outflow_currday", "intflow_currmonth", "outflow_currmonth", "intflow_curryear", "outflow_curryear"}).finish().addField("0", "sumlevel");
        DataSet sumResultSet = this.getSumDataSetByLevel(leftJoinDs, this.COUNT_FIELDS, "orgid,org_name,sortcode");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumResultSet = EmptyUtil.isNoEmpty((Object)subOrgIds) ? sumResultSet.filter("rowid in ids", Collections.singletonMap("ids", subOrgIds)) : sumResultSet.filter("rowid in ids", Collections.singletonMap("ids", paramMap.get("allorgids")));
        sumResultSet = sumResultSet.addField("'groupcol'", "groupcol");
        sumResultSet = DecisionAnlsHelper.removeNoDataTreeDs(sumResultSet, this.getSumFieldNames(), false);
        DataSet totalSet = this.addSubTotalDataSet(sumResultSet, Collections.singletonList("groupcol"), this.COUNT_FIELDS, "org_name").updateField("org_name", "'" + ((DynamicObject)parentOrgs.get(0)).getString("name") + "\uff08" + SettleCountFlowDataListPlugin.getLoadKDString() + "\uff09'");
        sumResultSet = sumResultSet.orderBy(new String[]{"sortcode"});
        return sumResultSet.union(totalSet);
    }

    private static String getLoadKDString() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SettleCountFlowDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private List<String> getSumFieldNames() {
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add("intflow_currday");
        fields.add("intflow_currmonth");
        fields.add("intflow_curryear");
        fields.add("outflow_currday");
        fields.add("outflow_currmonth");
        fields.add("outflow_curryear");
        return fields;
    }
}

