/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BigAmountFlowSumDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ORG_ID = "orgid";
    private static final String ROW_ID = "rowid";
    private static final String ORG_NAME = "orgname";
    private static final String SIMPLE_NAME = "simplename";
    private static final String DATE_RANGE = "dateRange";
    private static final String INFLOW_NUM = "inflownum";
    private static final String OUTFLOW_NUM = "outflownum";
    private static final List<String> SUM_FIELD = Arrays.asList("inflownum", "outflownum");
    private static final List<String> ORG_SELECTFIELD = Arrays.asList("orgid", "rowid", "orgname", "simplename", "pid", "isgroupnode", "level", "0  as sumlevel");

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{ORG_NAME, ResManager.loadKDString((String)"\u4e8c\u7ea7\u5355\u4f4d", (String)"BigAmountFlowSumDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{SIMPLE_NAME, ResManager.loadKDString((String)"\u4e8c\u7ea7\u5355\u4f4d\u7b80\u79f0", (String)"BigAmountFlowSumDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{INFLOW_NUM, ResManager.loadKDString((String)"\u6d41\u5165\u7b14\u6570", (String)"BigAmountFlowSumDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{OUTFLOW_NUM, ResManager.loadKDString((String)"\u6d41\u51fa\u7b14\u6570", (String)"BigAmountFlowSumDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{DATE_RANGE, ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"BigAmountFlowSumDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DateUtils.getDataFormat((Date)DecisionAnlsHelper.getQueryDate(paramMap), (boolean)false);
        DataSet allDs = SettleDataHelper.queryBigAmtSet((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, this.getOrgIds(paramMap), (Date)queryDate).select(new String[]{ORG_NAME, ORG_ID, "creditamount", "debitamount", "' ' as dateRange", "bizdate", "entityname"});
        DynamicObject bigAmountSet = BusinessDataServiceHelper.loadSingle((String)"tda_bigamountset", (String)"bigamountgetterway", (QFilter[])new QFilter[0]);
        String sourceType = bigAmountSet.getString("bigamountgetterway");
        allDs = allDs.addField("case entityname when 'cas_paybill' then '0' when 'cas_recbill' then '0' when 'bei_transdetail' then '1' end", "sourcetype");
        allDs = allDs.filter("sourcetype = '" + sourceType + "'");
        DataSet[] flowNumSets = allDs.splitByFilter(new String[]{"debitamount = 0", "creditamount = 0"}, false);
        DataSet inFlowNumDs = flowNumSets[0].select(new String[]{ORG_NAME, "'inflownum' distribute", "bizdate"}).groupBy(new String[]{ORG_NAME, "distribute", "bizdate"}).count().finish();
        DataSet outFlowNumDs = flowNumSets[1].select(new String[]{ORG_NAME, "'outflownum' distribute", "bizdate"}).groupBy(new String[]{ORG_NAME, "distribute", "bizdate"}).count().finish();
        DataSet flowNumSet = inFlowNumDs.union(outFlowNumDs);
        Date last7Day = DateUtils.getLastDay((Date)queryDate, (int)7);
        Date lastMonth = SettleDataHelper.getFirstDayTimeOfAnyMonth((Date)queryDate, (int)0);
        Date last2Month = SettleDataHelper.getFirstDayTimeOfAnyMonth((Date)queryDate, (int)-1);
        Date last6Month = SettleDataHelper.getFirstDayTimeOfAnyMonth((Date)queryDate, (int)-5);
        HashMap<String, Date> dateParamsMap = new HashMap<String, Date>(8);
        dateParamsMap.put("queryDate", queryDate);
        dateParamsMap.put("last7Day", last7Day);
        dateParamsMap.put("lastMonth", lastMonth);
        dateParamsMap.put("last2Month", last2Month);
        dateParamsMap.put("last6Month", last6Month);
        DataSet[] dataSets = DataSetHelper.splitByFilter((DataSet)flowNumSet, (String[])SettleDataHelper.FILTER_EXPRS, dateParamsMap, (boolean)false);
        DataSet sevenDayNumSet = this.changeRowToColDataSet(dataSets[0], "distribute", ORG_NAME, "");
        sevenDayNumSet = this.updateRowMeta(sevenDayNumSet).select(new String[]{ORG_NAME, INFLOW_NUM, OUTFLOW_NUM});
        DataSet oneMonthNumSet = this.changeRowToColDataSet(dataSets[1], "distribute", ORG_NAME, "");
        oneMonthNumSet = this.updateRowMeta(oneMonthNumSet).select(new String[]{ORG_NAME, INFLOW_NUM, OUTFLOW_NUM});
        DataSet twoMonthNumSet = this.changeRowToColDataSet(dataSets[2], "distribute", ORG_NAME, "");
        twoMonthNumSet = this.updateRowMeta(twoMonthNumSet).select(new String[]{ORG_NAME, INFLOW_NUM, OUTFLOW_NUM});
        DataSet sixMonthNumSet = this.changeRowToColDataSet(dataSets[3], "distribute", ORG_NAME, "");
        sixMonthNumSet = this.updateRowMeta(sixMonthNumSet).select(new String[]{ORG_NAME, INFLOW_NUM, OUTFLOW_NUM});
        DataSet sevenDaySumSet = this.getSumDataSetAndSort(paramMap, sevenDayNumSet).addField("'seven_day'", DATE_RANGE).select(new String[]{ORG_NAME, SIMPLE_NAME, INFLOW_NUM, OUTFLOW_NUM, DATE_RANGE});
        DataSet oneMonthSumSet = this.getSumDataSetAndSort(paramMap, oneMonthNumSet).addField("'one_month'", DATE_RANGE).select(new String[]{ORG_NAME, SIMPLE_NAME, INFLOW_NUM, OUTFLOW_NUM, DATE_RANGE});
        DataSet twoMonthSumSet = this.getSumDataSetAndSort(paramMap, twoMonthNumSet).addField("'two_month'", DATE_RANGE).select(new String[]{ORG_NAME, SIMPLE_NAME, INFLOW_NUM, OUTFLOW_NUM, DATE_RANGE});
        DataSet sixMonthSumSet = this.getSumDataSetAndSort(paramMap, sixMonthNumSet).addField("'six_month'", DATE_RANGE).select(new String[]{ORG_NAME, SIMPLE_NAME, INFLOW_NUM, OUTFLOW_NUM, DATE_RANGE});
        return sevenDaySumSet.union(new DataSet[]{oneMonthSumSet, twoMonthSumSet, sixMonthSumSet});
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_bigamountflowsumrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return DATE_RANGE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_bigamountflowsumrpt");
        parameter.setCaption(ResManager.loadKDString((String)"\u5927\u989d\u8d44\u91d1\u6d41\u5165\u6d41\u51fa\u5206\u6790\u8868", (String)"BigAmountFlowSumDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        parameter.getCustomParams().put(DATE_RANGE, ids.get(0));
        this.fireLinkageShowForm(view, parameter);
    }

    private DataSet updateRowMeta(DataSet dataSet) {
        Object[] fieldNames = dataSet.getRowMeta().getFieldNames();
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)INFLOW_NUM)) {
            dataSet = dataSet.addField("0", INFLOW_NUM);
        }
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)OUTFLOW_NUM)) {
            dataSet = dataSet.addField("0", OUTFLOW_NUM);
        }
        return dataSet;
    }

    private List<Long> getSubOrgIds(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        return TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
    }

    private DataSet getSumDataSetByLevel(DataSet treeData) {
        DataSet[] treeDsCopy = DataSetHelper.copy((DataSet)treeData);
        Set<Integer> levels = this.getLevels(treeDsCopy[0]);
        List levelList = levels.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        treeData = treeDsCopy[1];
        for (Integer level : levelList) {
            if (level == 1) continue;
            String filter = "level=" + level;
            String sumFieldSts = this.getSumFields(false);
            DataSet[] treeDsCp = DataSetHelper.copy((DataSet)treeData);
            GroupbyDataSet groupbyDataSet = treeDsCp[0].filter(filter).select(sumFieldSts.split(",")).groupBy(new String[]{"pid"});
            SUM_FIELD.forEach(field -> groupbyDataSet.sum("p" + field));
            DataSet detailSm = groupbyDataSet.finish();
            String joinFieldSts = this.getSumFields(true);
            treeData = treeDsCp[1].leftJoin(detailSm).on(ROW_ID, "pid").select(joinFieldSts.split(",")).finish();
        }
        return treeData;
    }

    private String getSumFields(boolean isJoin) {
        StringBuilder fieldStrs = new StringBuilder();
        String str = "pid,";
        if (isJoin) {
            str = "rowid, pid, isgroupnode, level, sumlevel,";
        }
        fieldStrs.append(str);
        for (String field : SUM_FIELD) {
            String expStr = field + " as p" + field;
            if (isJoin) {
                expStr = field + "+ p" + field + " as " + field;
            }
            fieldStrs.append(expStr).append(",");
        }
        if (isJoin) {
            return fieldStrs.append("orgid, orgname, simplename").toString();
        }
        return fieldStrs.substring(0, fieldStrs.length());
    }

    private Set<Integer> getLevels(DataSet treeData) {
        HashSet<Integer> levels = new HashSet<Integer>();
        DataSet levelDs = treeData.groupBy(new String[]{"level"}).finish();
        levelDs.forEach(o -> {
            if (o.getInteger("level") != null) {
                levels.add(o.getInteger("level"));
            }
        });
        return levels;
    }

    private DataSet getSumDataSetAndSort(Map<String, Object> paramMap, DataSet dataSet) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List filterOrg = this.getSubOrgIds(paramMap).stream().map(String::valueOf).collect(Collectors.toList());
        String orgFilter = "";
        orgFilter = CollectionUtils.isNotEmpty(filterOrg) ? "rowid in (" + String.join((CharSequence)",", filterOrg) + ")" : "rowid in " + orgId;
        DataSet resultSet = orgDataSet.leftJoin(dataSet).on(ORG_NAME, ORG_NAME).select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet).addField(String.join((CharSequence)"+", SUM_FIELD), "stat");
        if (StringUtils.isNotEmpty((String)orgFilter)) {
            sumDataSet = sumDataSet.filter(orgFilter).filter("stat > 0");
        }
        if (filterOrg.size() > 25) {
            sumDataSet = sumDataSet.orderBy(new String[]{"stat desc"}).top(25);
        }
        return sumDataSet;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet changeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var12_12;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            String fieldName = beginChangeField + fieldValue;
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var12_12).groupBy(new String[]{groupFieldName}).sum("count", fieldName).finish();
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            void var12_18;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var12_18.on(groupField.trim(), groupField.trim());
            }
            result = var12_18.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }
}

