/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.common.SettleConst;
import kd.tmc.tda.report.settle.common.SettleMgHelper;

public class SettleAmtFlowQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String[] GROUP_PROPS = new String[]{"company", "areaRange", "currency", "type"};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"intflow", ResManager.loadKDString((String)"\u6d41\u5165\u91d1\u989d", (String)"SettleAmtFlowQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"outflow", ResManager.loadKDString((String)"\u6d41\u51fa\u91d1\u989d", (String)"SettleAmtFlowQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"netamt", ResManager.loadKDString((String)"\u51c0\u6d41\u5165\u91d1\u989d", (String)"SettleAmtFlowQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"areaRange", ResManager.loadKDString((String)"\u533a\u57df", (String)"SettleAmtFlowQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"type", ResManager.loadKDString((String)"\u6c47\u603b\u7c7b\u578b", (String)"SettleAmtFlowQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"SettleAmtFlowQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        List<Long> allOrgIds = this.getOrgIds(paramMap);
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String sic = "company, currency, 'currday' as type, creditamount as intflow, debitamount as outflow, creditamount-debitamount as netamt, areaRange";
        DataSet currDayDs = SettleDataHelper.queryTransDetail((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, (Date)queryDate, allOrgIds, (String)"queryCurrDayAmt").filter("(creditamount <> 0 and debitamount = 0) or (debitamount <> 0 and creditamount = 0)").select(sic);
        DataSet currDayCountDs = currDayDs.groupBy(GROUP_PROPS).sum("intflow").sum("outflow").sum("netamt").finish();
        DataSet transDetails = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, allOrgIds, (Date)queryDate);
        String[] exprArr = new String[]{SettleMgHelper.getDateFilterStr("currmonth", queryDate, dateMap), SettleMgHelper.getDateFilterStr("curryear", queryDate, dateMap)};
        DataSet[] detailDS = DataSetHelper.splitByFilter((DataSet)transDetails, (String[])exprArr, dateMap, (boolean)false);
        String currMonthSic = "org as company,org_name,'currmonth' as type, currency, areaRange, creditamount as intflow, debitamount as outflow, creditamount-debitamount as netamt";
        DataSet currMonthCountDs = detailDS[0].select(currMonthSic).groupBy(GROUP_PROPS).sum("intflow").sum("outflow").sum("netamt").finish();
        currMonthSic = "org as company, org_name,'curryear' as type, currency, areaRange, creditamount as intflow, debitamount as outflow, creditamount-debitamount as netamt";
        DataSet currYearGroupDs = detailDS[1].select(currMonthSic).groupBy(GROUP_PROPS).sum("intflow").sum("outflow").sum("netamt").finish();
        DataSet allSet = currDayCountDs.union(currMonthCountDs).union(currYearGroupDs);
        DataSet groupDs = allSet.groupBy(new String[]{"areaRange", "type"}).sum("intflow").sum("outflow").sum("netamt").finish();
        groupDs = DecisionAnlsHelper.removeNoDataTreeDs(groupDs, this.getSumFieldNames(), false);
        groupDs = DecisionAnlsHelper.creatAbsentRow(groupDs, "type", Arrays.asList("currday", "currmonth", "curryear"), 1, () -> new Object[]{"domestic", "", 0.0, 0.0, 0.0});
        groupDs = groupDs.addField("areaRange", "param");
        return groupDs.updateField("areaRange", "case when areaRange = 'domestic' then '" + SettleConst.getDomesticType() + "' when areaRange = 'overseas' then '" + SettleConst.getForeignType() + "' end");
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_settleamtflowrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_settleamtflowrpt");
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put("areaRange", ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }

    private List<String> getSumFieldNames() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.addAll(this.getAmountFields());
        return fields;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("intflow");
        fields.add("outflow");
        fields.add("netamt");
        return fields;
    }
}

