/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.settle.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.SettleDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.settle.common.SettleConst;
import kd.tmc.tda.report.settle.common.SettleMgHelper;

public class SettleCountFlowQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String[] GROUP_PROPS = new String[]{"company", "areaRange", "currency", "sumtype"};

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"intflow", ResManager.loadKDString((String)"\u6d41\u5165\u7b14\u6570", (String)"SettleCountFlowQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"outflow", ResManager.loadKDString((String)"\u6d41\u51fa\u7b14\u6570", (String)"SettleCountFlowQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"areaRange", ResManager.loadKDString((String)"\u533a\u57df", (String)"SettleCountFlowQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"sumtype", ResManager.loadKDString((String)"\u6c47\u603b\u7c7b\u578b", (String)"SettleCountFlowQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"SettleCountFlowQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrencyId = (Long)paramMap.get("basecurrency");
        HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
        String sic = "company, currency, case when creditamount <> 0 and debitamount = 0 then 1 else 0 end as intflow, case when creditamount = 0 and debitamount <> 0 then 1 else 0 end as outflow,'currday' as sumtype, areaRange";
        DataSet currDayDs = SettleDataHelper.queryTransDetail((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, (Date)queryDate, this.getOrgIds(paramMap), (String)"queryCurrDayAmt").filter("(creditamount <> 0 and debitamount = 0) or (debitamount <> 0 and creditamount = 0)").select(sic);
        DataSet currDayCountDs = currDayDs.groupBy(GROUP_PROPS).sum("intflow").sum("outflow").finish();
        String currMonthSic = "org as company, org_name, 'currmonth' as sumtype, currency, areaRange, creditcount as intflow, debitcount as outflow";
        DataSet transDetails = SettleDataHelper.queryTransDetailsSummary((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (Long)baseCurrencyId, this.getOrgIds(paramMap), (Date)queryDate);
        DataSet currMonthDs = transDetails.copy().filter(SettleMgHelper.getDateFilterStr("currmonth", queryDate, dateMap), dateMap).select(currMonthSic);
        DataSet currMonthCountDs = currMonthDs.groupBy(GROUP_PROPS).sum("intflow").sum("outflow").finish();
        String currYearSic = "org as company, org_name, 'curryear' as sumtype, currency, areaRange, creditcount as intflow, debitcount as outflow";
        DataSet currYearDs = transDetails.filter(SettleMgHelper.getDateFilterStr("curryear", queryDate, dateMap), dateMap).select(currYearSic);
        DataSet currYearGroupDs = currYearDs.groupBy(GROUP_PROPS).sum("intflow").sum("outflow").finish();
        DataSet allSet = currDayCountDs.union(currMonthCountDs).union(currYearGroupDs);
        DataSet groupDs = allSet.groupBy(new String[]{"areaRange", "sumtype"}).sum("intflow").sum("outflow").finish();
        groupDs = DecisionAnlsHelper.removeNoDataTreeDs(groupDs, this.getSumFieldNames(), false);
        groupDs = groupDs.addField("areaRange", "param");
        return groupDs.updateField("areaRange", "case when areaRange = 'domestic' then '" + SettleConst.getDomesticType() + "' when areaRange = 'overseas' then '" + SettleConst.getForeignType() + "' end");
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_settlecountflowrpt");
    }

    private List<String> getSumFieldNames() {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("intflow");
        fields.add("outflow");
        return fields;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_settlecountflowrpt");
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put("areaRange", ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }
}

