/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.synthesis.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SynthesisProjectEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.propertys.SynthesisProp;
import kd.tmc.tda.report.cash.qing.data.CashDomesticAndForeignQingAnlsPlugin;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.qing.data.FinDebtByRegionDataPlugin;
import kd.tmc.tda.report.finance.qing.data.FinDebtSumDataPlugin;
import kd.tmc.tda.report.synthesis.qing.data.SynthesisQingRptDataPlugin;

public class SynthesisRptDataHelper {
    private static final Log logger = LogFactory.getLog(SynthesisQingRptDataPlugin.class);
    private static final Integer DEFAULT_SCALE = 4;
    public static final String FORMAT_YM = "yyyy-MM";
    private static final String[] fields = new String[]{"project", "currmonthtotal", "lastmonthtotal", "currmonthdomestic", "lastmonthdomestic", "currmonthforeign", "lastmonthforeign", "budget", "relbudget", "changeamt", "changerate", "sort"};
    private static final DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.IntegerType};

    public static DataSet queryRptData(String algoKey, List<Long> orgIds, Map<String, Object> paramMap) {
        long start = System.currentTimeMillis();
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        DynamicObject org = (DynamicObject)paramMap.get("org");
        DynamicObject currency = (DynamicObject)paramMap.get("currency");
        SynthesisQingRptDataPlugin dateLocal = new SynthesisQingRptDataPlugin();
        dateLocal.queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        dateLocal.queryDate = DecisionCommonHelper.fixQueryDate((Date)dateLocal.queryDate);
        QFilter orgViewFilter = new QFilter("orgview.id", "=", orgView.getPkValue());
        QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
        DataSet assetsDebtRateDs = SynthesisRptDataHelper.createAssetsDebtRateDs(orgViewFilter, orgFilter, dateLocal, algoKey);
        DataSet fundDs = SynthesisRptDataHelper.createCashFundDs(orgView, org, dateLocal.queryDate, currency, algoKey);
        DataSet profitRateDs = SynthesisRptDataHelper.createProfitRateDs(paramMap, orgIds, dateLocal.queryDate, algoKey);
        DataSet intdebtAmtDs = SynthesisRptDataHelper.createIntDebtAmtDs(orgView, org, dateLocal.queryDate, currency, algoKey);
        DataSet fincostDs = SynthesisRptDataHelper.createFinCostDs(paramMap, orgIds, dateLocal.queryDate, algoKey);
        DataSet netAssetsDs = SynthesisRptDataHelper.createNetAssetsDs(orgViewFilter, orgFilter, dateLocal, algoKey);
        DataSet equityAmtDs = SynthesisRptDataHelper.createEquityAmtDs(orgViewFilter, orgFilter, dateLocal, algoKey);
        DataSet intDebtRateDs = SynthesisRptDataHelper.createIntDebtRateDs(orgViewFilter, orgFilter, dateLocal, algoKey);
        DataSet intDebtEquityRateDs = SynthesisRptDataHelper.createIntDebtEquityRateDs(orgViewFilter, orgFilter, dateLocal, algoKey);
        DataSet resultDs = fundDs.union(new DataSet[]{profitRateDs, intdebtAmtDs, fincostDs, netAssetsDs, equityAmtDs, assetsDebtRateDs, intDebtRateDs, intDebtEquityRateDs}).orderBy(new String[]{"sort"});
        resultDs = resultDs.addField("to_date('" + DateUtils.formatString((Date)dateLocal.queryDate, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate");
        logger.info("\u3010\u7efc\u5408\u5206\u6790\u62a5\u8868\u3011\u53d6\u6570\uff1a" + algoKey + "cost:" + (System.currentTimeMillis() - start));
        return resultDs;
    }

    private static DataSet createCashFundDs(DynamicObject orgView, DynamicObject org, Date queryDate, DynamicObject currency, String algoKey) {
        return SynthesisRptDataHelper.createAmtDs(orgView, org, currency, queryDate, "tda_cashdomandforqingrpt", SynthesisProjectEnum.FD.getValue(), algoKey, 1);
    }

    private static DataSet createProfitRateDs(Map<String, Object> paramMap, List<Long> orgIds, Date queryDate, String algoKey) {
        String projectName = SynthesisProjectEnum.PR.getValue();
        try {
            Date lastMonthEndDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
            DataSet currMonthDs = SynthesisRptDataHelper.getCashCateDs(paramMap, lastMonthEndDate, orgIds, algoKey);
            Map<String, BigDecimal> currMonthRate = SynthesisRptDataHelper.getProfitRegionRate(currMonthDs, algoKey);
            BigDecimal currMonthDomesticRate = currMonthRate.get("domestic");
            BigDecimal currMonthForeignRate = currMonthRate.get("foreign");
            Date lastLMonthEndDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-2);
            DataSet lastMonthDs = SynthesisRptDataHelper.getCashCateDs(paramMap, lastLMonthEndDate, orgIds, algoKey);
            Map<String, BigDecimal> lastMonthRate = SynthesisRptDataHelper.getProfitRegionRate(lastMonthDs, algoKey);
            BigDecimal lastMonthDomesticRate = lastMonthRate.get("domestic");
            BigDecimal lastMonthForeignRate = lastMonthRate.get("foreign");
            BigDecimal currMonthTotalRate = SynthesisRptDataHelper.getProfitTotalRate(currMonthDs);
            BigDecimal lastMonthTotalRate = SynthesisRptDataHelper.getProfitTotalRate(lastMonthDs);
            BigDecimal changeAmt = currMonthTotalRate.subtract(lastMonthTotalRate);
            BigDecimal changeRate = lastMonthTotalRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currMonthTotalRate.subtract(lastMonthTotalRate).divide(lastMonthTotalRate, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
            ArrayList<Object[]> dataSetRow = new ArrayList<Object[]>(1);
            dataSetRow.add(new Object[]{projectName, currMonthTotalRate, lastMonthTotalRate, currMonthDomesticRate, lastMonthDomesticRate, currMonthForeignRate, lastMonthForeignRate, BigDecimal.ZERO, BigDecimal.ZERO, changeAmt, changeRate, 2});
            return DecisionAnlsHelper.createRow(algoKey + ".createFinCostDs", fields, dataTypes, dataSetRow);
        }
        catch (Exception e) {
            logger.error(algoKey + "\u83b7\u53d6\u6536\u76ca\u7387\uff08\u5e74\u5316\uff09\u6570\u636e\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return SynthesisRptDataHelper.createEmptyDataSet(projectName, 2, algoKey);
        }
    }

    private static DataSet getCashCateDs(Map<String, Object> paramMap, Date lastMonthEndDate, List<Long> orgIds, String algoKey) {
        String selectPropsTemp = "realvalibalance+realrestrictedamt fbalance, frate, isdomestic,fundtype,fundtypename";
        return CashFundsDataHelper.getFundDataSet((String)(algoKey + ".getCashCateDs"), orgIds, (Date)lastMonthEndDate, paramMap, (boolean)false, (boolean)true).filter("isoffset='0' and fundtype!=0").select(selectPropsTemp);
    }

    private static DataSet createIntDebtAmtDs(DynamicObject orgView, DynamicObject org, Date queryDate, DynamicObject currency, String algoKey) {
        return SynthesisRptDataHelper.createAmtDs(orgView, org, currency, queryDate, "tda_findebtsumqrpt", SynthesisProjectEnum.IDA.getValue(), algoKey, 3);
    }

    private static DataSet createFinCostDs(Map<String, Object> paramMap, List<Long> orgIds, Date queryDate, String algoKey) {
        String projectName = SynthesisProjectEnum.FC.getValue();
        try {
            Date lastMonthEndDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
            DataSet currMonthDs = SynthesisRptDataHelper.getFinCostDs(paramMap, lastMonthEndDate, orgIds, algoKey);
            Map<String, BigDecimal> currMonthRate = SynthesisRptDataHelper.getFinCostRegionMap(currMonthDs, algoKey);
            BigDecimal currMonthDomesticRate = currMonthRate.get("domestic");
            BigDecimal currMonthForeignRate = currMonthRate.get("foreign");
            Date lastLMonthEndDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-2);
            DataSet lastMonthDs = SynthesisRptDataHelper.getFinCostDs(paramMap, lastLMonthEndDate, orgIds, algoKey);
            Map<String, BigDecimal> lastMonthRate = SynthesisRptDataHelper.getFinCostRegionMap(lastMonthDs, algoKey);
            BigDecimal lastMonthDomesticRate = lastMonthRate.get("domestic");
            BigDecimal lastMonthForeignRate = lastMonthRate.get("foreign");
            BigDecimal currMonthTotalRate = SynthesisRptDataHelper.getFinCostTotalRate(currMonthDs);
            BigDecimal lastMonthTotalRate = SynthesisRptDataHelper.getFinCostTotalRate(lastMonthDs);
            BigDecimal changeAmt = currMonthTotalRate.subtract(lastMonthTotalRate);
            BigDecimal changeRate = lastMonthTotalRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currMonthTotalRate.subtract(lastMonthTotalRate).divide(lastMonthTotalRate, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
            ArrayList<Object[]> dataSetRow = new ArrayList<Object[]>(1);
            dataSetRow.add(new Object[]{projectName, currMonthTotalRate, lastMonthTotalRate, currMonthDomesticRate, lastMonthDomesticRate, currMonthForeignRate, lastMonthForeignRate, BigDecimal.ZERO, BigDecimal.ZERO, changeAmt, changeRate, 4});
            return DecisionAnlsHelper.createRow(algoKey + ".createFinCostDs", fields, dataTypes, dataSetRow);
        }
        catch (Exception e) {
            logger.error(algoKey + "\u83b7\u53d6\u878d\u8d44\u6210\u672c\uff08\u5e74\u5316\uff09\u6570\u636e\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return SynthesisRptDataHelper.createEmptyDataSet(projectName, 4, algoKey);
        }
    }

    private static DataSet createNetAssetsDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String algoKey) {
        return SynthesisRptDataHelper.createLiquidityDs(orgViewFilter, orgFilter, dateLocal, SynthesisProjectEnum.NA.getValue(), "ownerequityamt", "netassetsamt", algoKey, 5);
    }

    private static DataSet createEquityAmtDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String algoKey) {
        return SynthesisRptDataHelper.createLiquidityDs(orgViewFilter, orgFilter, dateLocal, SynthesisProjectEnum.EA.getValue(), "equityamt", "equityamt", algoKey, 6);
    }

    private static DataSet createAssetsDebtRateDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String algoKey) {
        return SynthesisRptDataHelper.createLiquidityDs(orgViewFilter, orgFilter, dateLocal, SynthesisProjectEnum.ADR.getValue(), "assetsdebtrate", "assetsdebtrate", algoKey, 7);
    }

    private static DataSet createIntDebtRateDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String algoKey) {
        return SynthesisRptDataHelper.createLiquidityDs(orgViewFilter, orgFilter, dateLocal, SynthesisProjectEnum.IDR.getValue(), "intdebtrate", "intdebtrate", algoKey, 8);
    }

    private static DataSet createIntDebtEquityRateDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String algoKey) {
        return SynthesisRptDataHelper.createLiquidityDs(orgViewFilter, orgFilter, dateLocal, SynthesisProjectEnum.IDER.getValue(), "intdebtequityrate", "intdebtequityrate", algoKey, 9);
    }

    private static DataSet createAmtDs(DynamicObject orgView, DynamicObject org, DynamicObject currency, Date queryDate, String formId, String projectName, String algoKey, int sort) {
        QFilter orgViewFilter = new QFilter("orgview", "=", (Object)orgView);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)currency);
        QFilter dateFilter = SynthesisRptDataHelper.getMonthFilter(queryDate, -1);
        QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, currencyFilter, dateFilter};
        try {
            DataSet currMonthDs = SynthesisRptDataHelper.getBizDs(formId, qFilters);
            String regionProp = SynthesisRptDataHelper.getRegionProp(formId);
            String amtProp = SynthesisRptDataHelper.getAmtProp(formId);
            String domesticVal = SynthesisRptDataHelper.getDomesticValue(formId);
            Map<String, BigDecimal> currMonthAmt = SynthesisRptDataHelper.getAmtMap(currMonthDs, regionProp, amtProp, domesticVal, algoKey);
            BigDecimal currMonthDomesticAmt = currMonthAmt.get("domestic");
            BigDecimal currMonthForeignAmt = currMonthAmt.get("foreign");
            dateFilter = SynthesisRptDataHelper.getMonthFilter(queryDate, -2);
            qFilters = new QFilter[]{orgViewFilter, orgFilter, currencyFilter, dateFilter};
            DataSet lastMonthDs = SynthesisRptDataHelper.getBizDs(formId, qFilters);
            Map<String, BigDecimal> lastMonthAmt = SynthesisRptDataHelper.getAmtMap(lastMonthDs, regionProp, amtProp, domesticVal, algoKey);
            BigDecimal lastMonthDomesticAmt = lastMonthAmt.get("domestic");
            BigDecimal lastMonthForeignAmt = lastMonthAmt.get("foreign");
            BigDecimal currMonthTotalAmt = currMonthDomesticAmt.add(currMonthForeignAmt);
            BigDecimal lastMonthTotalAmt = lastMonthDomesticAmt.add(lastMonthForeignAmt);
            BigDecimal budgetAmt = BigDecimal.ZERO;
            BigDecimal relBudgetAmt = BigDecimal.ZERO;
            if ("tda_findebtsumqrpt".equals(formId)) {
                int year = DateUtils.getYear((Date)queryDate);
                orgViewFilter = new QFilter("orgview.id", "=", orgView.getPkValue());
                qFilters = new QFilter[]{orgViewFilter, orgFilter = new QFilter("org.id", "=", org.getPkValue()), dateFilter = new QFilter("budgetyear", "=", (Object)year)};
                Object[] budgetDs = TmcDataServiceHelper.load((String)"tda_budgetbill", (String)"intdebtamt", (QFilter[])qFilters);
                if (EmptyUtil.isNoEmpty((Object[])budgetDs)) {
                    budgetAmt = budgetDs[0].getBigDecimal("intdebtamt");
                    relBudgetAmt = currMonthTotalAmt.subtract(budgetAmt);
                }
            }
            BigDecimal changeAmt = currMonthTotalAmt.subtract(lastMonthTotalAmt);
            BigDecimal changeRate = lastMonthTotalAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currMonthTotalAmt.subtract(lastMonthTotalAmt).divide(lastMonthTotalAmt, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
            ArrayList<Object[]> dataSetRow = new ArrayList<Object[]>(1);
            dataSetRow.add(new Object[]{projectName, currMonthTotalAmt, lastMonthTotalAmt, currMonthDomesticAmt, lastMonthDomesticAmt, currMonthForeignAmt, lastMonthForeignAmt, budgetAmt, relBudgetAmt, changeAmt, changeRate.multiply(new BigDecimal(100)), sort});
            return DecisionAnlsHelper.createRow(algoKey + ".createAmtDs", fields, dataTypes, dataSetRow);
        }
        catch (Exception e) {
            logger.error(algoKey + "---" + formId + " -- \u83b7\u53d6\u6570\u636e\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return SynthesisRptDataHelper.createEmptyDataSet(projectName, sort, algoKey);
        }
    }

    private static DataSet createLiquidityDs(QFilter orgViewFilter, QFilter orgFilter, SynthesisQingRptDataPlugin dateLocal, String projectName, String liquidityProp, String budgetProp, String algoKey, int sort) {
        int year;
        Object[] budgetDs;
        Object[] lastMonthDs;
        QFilter[] qFilters;
        QFilter dateFilter;
        BigDecimal budgetAmt;
        BigDecimal lastMonthAmt;
        BigDecimal currMonthAmt;
        block8: {
            currMonthAmt = BigDecimal.ZERO;
            lastMonthAmt = BigDecimal.ZERO;
            budgetAmt = BigDecimal.ZERO;
            if (SynthesisProjectEnum.ADR.getValue().equals(projectName)) {
                Object[] paramsObjs = new Object[8];
                QFilter dateFilter2 = SynthesisRptDataHelper.getLiquidityQFilter(dateLocal.queryDate, paramsObjs);
                QFilter[] qFilters2 = new QFilter[]{orgViewFilter, orgFilter, dateFilter2};
                String selStr = liquidityProp + ",accountyear,accountperiod";
                Object[] currMonthDs = TmcDataServiceHelper.load((String)"tda_liquiditybill", (String)selStr, (QFilter[])qFilters2, (String)"accountyear desc,accountperiod desc");
                if (EmptyUtil.isNoEmpty((Object[])currMonthDs)) {
                    int year2 = currMonthDs[0].getInt("accountyear");
                    int period = currMonthDs[0].getInt("accountperiod");
                    dateLocal.queryDate = DateUtils.getFirstDateOfAnyMonth((Date)DateUtils.stringToDate((String)(year2 + "-" + period), (String)FORMAT_YM), (int)1);
                    for (int i = 1; i <= 4; ++i) {
                        int accountyear = (Integer)paramsObjs[2 * (i - 1)];
                        int accountperiod = (Integer)paramsObjs[2 * i - 1];
                        for (Object currMonth : currMonthDs) {
                            if (accountyear != currMonth.getInt("accountyear") || accountperiod != currMonth.getInt("accountperiod") || currMonth.getBigDecimal(liquidityProp).compareTo(BigDecimal.ZERO) == 0) continue;
                            currMonthAmt = currMonth.getBigDecimal(liquidityProp);
                            dateLocal.queryDate = DateUtils.getFirstDateOfAnyMonth((Date)DateUtils.stringToDate((String)(accountyear + "-" + accountperiod), (String)FORMAT_YM), (int)1);
                            break block8;
                        }
                    }
                }
            } else {
                dateFilter = SynthesisRptDataHelper.getLiquidityQFilter(dateLocal.queryDate, -1);
                qFilters = new QFilter[]{orgViewFilter, orgFilter, dateFilter};
                Object[] currMonthDs = TmcDataServiceHelper.load((String)"tda_liquiditybill", (String)liquidityProp, (QFilter[])qFilters);
                if (EmptyUtil.isNoEmpty((Object[])currMonthDs)) {
                    currMonthAmt = currMonthDs[0].getBigDecimal(liquidityProp);
                }
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])(lastMonthDs = TmcDataServiceHelper.load((String)"tda_liquiditybill", (String)liquidityProp, (QFilter[])(qFilters = new QFilter[]{orgViewFilter, orgFilter, dateFilter = SynthesisRptDataHelper.getLiquidityQFilter(dateLocal.queryDate, -2)}))))) {
            lastMonthAmt = lastMonthDs[0].getBigDecimal(liquidityProp);
        }
        if (EmptyUtil.isNoEmpty((Object[])(budgetDs = TmcDataServiceHelper.load((String)"tda_budgetbill", (String)budgetProp, (QFilter[])(qFilters = new QFilter[]{orgViewFilter, orgFilter, dateFilter = new QFilter("budgetyear", "=", (Object)(year = DateUtils.getYear((Date)dateLocal.queryDate)))}))))) {
            budgetAmt = budgetDs[0].getBigDecimal(budgetProp);
        }
        BigDecimal relBudgetAmt = currMonthAmt.subtract(budgetAmt);
        BigDecimal changeAmt = currMonthAmt.subtract(lastMonthAmt);
        BigDecimal changeRate = lastMonthAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : currMonthAmt.subtract(lastMonthAmt).divide(lastMonthAmt, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
        ArrayList<Object[]> dataSetRow = new ArrayList<Object[]>(1);
        dataSetRow.add(new Object[]{projectName, currMonthAmt, lastMonthAmt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, budgetAmt, relBudgetAmt, changeAmt, changeRate, sort});
        return DecisionAnlsHelper.createRow(algoKey + ".createNetAssetsDs", fields, dataTypes, dataSetRow);
    }

    private static String getAmtProp(String formId) {
        String amtProp = "amount";
        if ("tda_findebtsumqrpt".equals(formId)) {
            amtProp = "totaldebt";
        }
        return amtProp;
    }

    private static String getRegionProp(String formId) {
        String regionProp = "areatype";
        if ("tda_findebtsumqrpt".equals(formId)) {
            regionProp = "region";
        }
        return regionProp;
    }

    private static String getDomesticValue(String formId) {
        String domesticValue = CashDomesticAndForeignQingAnlsPlugin.getDomesticType();
        if ("tda_findebtsumqrpt".equals(formId)) {
            domesticValue = FinDebtSumDataPlugin.getDomesticType();
        }
        return domesticValue;
    }

    private static Map<String, BigDecimal> getProfitRegionRate(DataSet bizDs, String algoKey) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(4);
        DataSet groupDs = bizDs.copy().groupBy(new String[]{"isdomestic"}).sum("fbalance").sum("fbalance*frate", "temp").finish();
        String sic = "isdomestic,fbalance,temp,case when fbalance=0 then 0 else temp*1.0/fbalance end as profit";
        groupDs = groupDs.select(sic).removeFields(new String[]{"temp"});
        for (Row row : groupDs) {
            Integer region = row.getInteger("isdomestic");
            BigDecimal profit = row.getBigDecimal("profit");
            if (SynthesisProp.REGION_DOMESTIC.equals(region)) {
                result.put("domestic", profit);
                continue;
            }
            result.put("foreign", profit);
        }
        logger.info(algoKey + "\u6536\u76ca\u7387\u53d6\u6570\u7ed3\u679c\uff1a" + result);
        return result;
    }

    private static BigDecimal getProfitTotalRate(DataSet bizDs) {
        BigDecimal profitTotalRate = BigDecimal.ZERO;
        bizDs = bizDs.addField("0", "groupfield");
        DataSet groupDs = bizDs.groupBy(new String[]{"groupfield"}).sum("fbalance").sum("fbalance*frate", "temp").finish();
        String sic = "fbalance,temp,case when fbalance=0 then 0 else temp*1.0/fbalance end as profit";
        groupDs = groupDs.select(sic).removeFields(new String[]{"temp"});
        for (Row row : groupDs) {
            profitTotalRate = row.getBigDecimal("profit");
        }
        return profitTotalRate;
    }

    private static Map<String, BigDecimal> getFinCostRegionMap(DataSet bizDs, String algoKey) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(4);
        DataSet groupDs = bizDs.copy().groupBy(new String[]{"region"}).sum("repayamount * loanrate end ", "avasumrateamount").sum("repayamount", "avasumamount").finish().addField("case when avasumamount = 0 then 0 else avasumrateamount/avasumamount end", "avasumrate");
        for (Row row : groupDs) {
            try {
                int region = row.getInteger("region");
                BigDecimal avaSumRate = row.getBigDecimal("avasumrate");
                if (SynthesisProp.REGION_DOMESTIC == region) {
                    result.put("domestic", avaSumRate);
                    continue;
                }
                result.put("foreign", avaSumRate);
            }
            catch (Exception e) {
                logger.info(algoKey + "\u878d\u8d44\u6210\u672c\u53d6\u6570\u9519\u8bef\uff1a", (Object)e);
            }
        }
        logger.info(algoKey + "\u878d\u8d44\u6210\u672c\u53d6\u6570\u7ed3\u679c\uff1a" + result);
        return result;
    }

    private static BigDecimal getFinCostTotalRate(DataSet bizDs) {
        BigDecimal finCostTotalRate = BigDecimal.ZERO;
        bizDs = bizDs.addField("0", "groupfield");
        DataSet groupDs = bizDs.groupBy(new String[]{"groupfield"}).sum("repayamount * loanrate end ", "avasumrateamount").sum("repayamount", "avasumamount").finish().addField("case when avasumamount = 0 then 0 else avasumrateamount/avasumamount end", "avasumrate");
        for (Row row : groupDs) {
            finCostTotalRate = row.getBigDecimal("avasumrate");
        }
        return finCostTotalRate;
    }

    private static DataSet getFinCostDs(Map<String, Object> paramMap, Date date, List<Long> orgIds, String algoKey) {
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        DynamicObject org = (DynamicObject)paramMap.get("org");
        DynamicObject currency = (DynamicObject)paramMap.get("currency");
        return FinanceDataHelper.getFinanceDataSet((String)(algoKey + ".getFinCostDs"), orgIds, (Date)date, (Long)currency.getLong("id"), (Long)orgView.getLong("id"), (Long)org.getLong("id")).filter("isequity = false").updateField("repayamount", String.join((CharSequence)"+", "repayamount", MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME));
    }

    private static Map<String, BigDecimal> getAmtMap(DataSet bizDs, String regionProp, String amtProp, String domesticVal, String algoKey) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(4);
        DataSet groupDs = bizDs.groupBy(new String[]{regionProp}).sum(amtProp).finish();
        for (Row row : groupDs) {
            String areaType = row.getString(regionProp);
            BigDecimal amount = row.getBigDecimal(amtProp);
            if (domesticVal.equals(areaType)) {
                result.put("domestic", amount);
                continue;
            }
            result.put("foreign", amount);
        }
        logger.info(algoKey + "\u8d27\u5e01\u8d44\u91d1\u6709\u606f\u8d1f\u503a\u53d6\u6570\u7ed3\u679c\uff1a" + result);
        return result;
    }

    public static QFilter getLiquidityQFilter(Date queryDate, Object[] paramsObjs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 4; ++i) {
            Date month = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-i));
            sb.append("(accountyear = ? and accountperiod = ?)");
            if (i != 4) {
                sb.append(" or ");
            }
            paramsObjs[2 * (i - 1)] = DateUtils.getYear((Date)month);
            paramsObjs[2 * i - 1] = DateUtils.getMonth((Date)month);
        }
        return QFilter.of((String)sb.toString(), (Object[])paramsObjs);
    }

    private static QFilter getLiquidityQFilter(Date queryDate, int i) {
        Date month = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)i);
        QFilter dateFilter = new QFilter("accountyear", "=", (Object)DateUtils.getYear((Date)month));
        dateFilter.and("accountperiod", "=", (Object)DateUtils.getMonth((Date)month));
        return dateFilter;
    }

    private static DataSet getBizDs(String formId, QFilter[] qFilters) throws Exception {
        AbstractDecisionAnlsQingDataPlugin service = new CashDomesticAndForeignQingAnlsPlugin();
        if ("tda_findebtsumqrpt".equals(formId)) {
            service = new FinDebtByRegionDataPlugin();
        }
        return service.data(formId, "", qFilters);
    }

    private static QFilter getMonthFilter(Date queryDate, int i) {
        Date lastMonthEndDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)i);
        return new QFilter("querydate", "=", (Object)lastMonthEndDate);
    }

    private static DataSet createEmptyDataSet(String projectName, int sort, String algoKey) {
        ArrayList<Object[]> dataSetRow = new ArrayList<Object[]>(1);
        dataSetRow.add(new Object[]{projectName, 0, 0, 0, 0, 0, 0, BigDecimal.ZERO, BigDecimal.ZERO, 0, 0, sort});
        return DecisionAnlsHelper.createRow(algoKey + ".createNetAssetsDs", fields, dataTypes, dataSetRow);
    }
}

