/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.synthesis.qing.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.tmc.tda.extpoint.synthesis.ISynthesisLoadDataInterface;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.SynthesisProjectEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SynthsisSumDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class SynthesisDiagramTableDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final Log logger = LogFactory.getLog(SynthesisDiagramTableDataPlugin.class);
    private static String[] newFieldNames = new String[]{"project", "currmonthtotal", "lastmonthtotal", "currmonthdomestic", "lastmonthdomestic", "currmonthforeign", "lastmonthforeign", "budget", "relbudget", "changeamt", "changerate", "bizdate"};
    private static DataType[] newDataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.DateType};
    private Map<String, BigDecimal> rateCache = new HashMap<String, BigDecimal>(16);

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"project", ResManager.loadKDString((String)"\u9879\u76ee", (String)"SynthesisDiagramTableDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"currmonthtotal", ResManager.loadKDString((String)"\u672c\u6708\u5408\u8ba1", (String)"SynthesisDiagramTableDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"lastmonthtotal", ResManager.loadKDString((String)"\u4e0a\u6708\u5408\u8ba1", (String)"SynthesisDiagramTableDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"currmonthdomestic", ResManager.loadKDString((String)"\u672c\u6708\u5883\u5185", (String)"SynthesisDiagramTableDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"lastmonthdomestic", ResManager.loadKDString((String)"\u4e0a\u6708\u5883\u5185", (String)"SynthesisDiagramTableDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"currmonthforeign", ResManager.loadKDString((String)"\u672c\u6708\u5883\u5916", (String)"SynthesisDiagramTableDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"lastmonthforeign", ResManager.loadKDString((String)"\u4e0a\u6708\u5883\u5916", (String)"SynthesisDiagramTableDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"budget", ResManager.loadKDString((String)"\u9884\u7b97", (String)"SynthesisDiagramTableDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"relbudget", ResManager.loadKDString((String)"\u8f83\u9884\u7b97", (String)"SynthesisDiagramTableDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"changeamt", ResManager.loadKDString((String)"\u53d8\u5316\u989d", (String)"SynthesisDiagramTableDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"changerate", ResManager.loadKDString((String)"\u53d8\u5316\u7387", (String)"SynthesisDiagramTableDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u65e5\u671f", (String)"SynthesisDiagramTableDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Date.toNumber(), false});
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        long startTime = System.currentTimeMillis();
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        DynamicObject org = (DynamicObject)paramMap.get("org");
        DynamicObject currency = (DynamicObject)paramMap.get("currency");
        String amoutUnit = (String)paramMap.get("amountunit");
        Date queryDate = DecisionCommonHelper.fixQueryDate((Date)DecisionAnlsHelper.getQueryDate(paramMap));
        List<Map<String, Object>> list = Collections.EMPTY_LIST;
        Date bizDate = null;
        String lockKey = orgView.getLong("id") + "-" + org.getLong("id") + "-" + DateUtils.formatString((Date)DateUtils.getFirstDayOfMonth((Date)queryDate), (String)"yyyy-MM-dd");
        DLock dLock = DLock.create((String)lockKey);
        if (dLock.tryLock(60000L)) {
            logger.info("\u3010\u7efc\u5408\u5206\u6790\u3011\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f lock key :" + lockKey);
            try {
                Object[] existSumData = this.getExistSumData(orgView, org, queryDate);
                Date curyyMM = DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)0);
                if (EmptyUtil.isNoEmpty((Object[])existSumData)) {
                    bizDate = existSumData[0].getDate("bizdate");
                    if (curyyMM.equals(bizDate)) {
                        list = this.loadRptSumDataFromDB(orgView, org, queryDate, currency, amoutUnit, (DynamicObject[])existSumData);
                    }
                    list = this.loadRptSumDataFromPlugin(orgView, org, queryDate, currency, amoutUnit, curyyMM);
                }
                long createStartTime = System.currentTimeMillis();
                bizDate = queryDate;
                list = this.loadRptSumDataFromPlugin(orgView, org, queryDate, currency, amoutUnit, curyyMM);
                logger.info("\u7efc\u5408\u5206\u6790\u521b\u5efa\u6570\u636e\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - createStartTime));
            }
            catch (Exception e) {
                logger.error("\u3010\u7efc\u5408\u5206\u6790\u3011\u53d6\u6570\u65f6\u9519\u8bef lock key: " + lockKey + " \u9519\u8bef\u4fe1\u606f\uff1a" + e);
            }
            finally {
                dLock.unlock();
            }
        } else {
            logger.info("\u3010\u7efc\u5408\u5206\u6790\u3011\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25 lock key :" + lockKey);
            list = Collections.EMPTY_LIST;
        }
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"SynthesisDiagramTableDataPlugin.createDataSet").createDataSetBuilder(builderMeta);
        for (Map map : list) {
            ArrayList<Object> appendRow = new ArrayList<Object>(newFieldNames.length);
            appendRow.add(map.get("project"));
            appendRow.add(map.get("currmonthtotal"));
            appendRow.add(map.get("lastmonthtotal"));
            appendRow.add(map.get("currmonthdomestic"));
            appendRow.add(map.get("lastmonthdomestic"));
            appendRow.add(map.get("currmonthforeign"));
            appendRow.add(map.get("lastmonthforeign"));
            appendRow.add(map.get("budget"));
            appendRow.add(map.get("relbudget"));
            appendRow.add(map.get("changeamt"));
            appendRow.add(map.get("changerate"));
            appendRow.add(bizDate);
            builder.append(appendRow.toArray());
        }
        DataSet result = builder.build();
        if (result == null) {
            logger.info("\u7efc\u5408\u5206\u6790\u53d6\u6570\u4e3a\u7a7a");
        }
        logger.info("\u7efc\u5408\u5206\u6790\u53d6\u6570\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
        return result;
    }

    private DynamicObject[] getExistSumData(DynamicObject orgView, DynamicObject org, Date queryDate) {
        QFilter orgViewFilter = new QFilter("orgview.id", "=", orgView.getPkValue());
        QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
        Long baseCurrencyId = AmountTransHelper.getBaseCurrency((Long)orgView.getLong("id"));
        QFilter currencyFilter = new QFilter("currency.id", "=", (Object)baseCurrencyId);
        List<Date> firstDayOfMonthList = this.getfirstDayOfMonthsByQueryDate(queryDate);
        QFilter dateFilter = new QFilter("bizdate", "in", firstDayOfMonthList);
        DynamicObject[] existSumData = TmcDataServiceHelper.load((String)"tda_synthesissumdata", (String)"bizdate,currency,project,currmonthtotal,lastmonthtotal,currmonthdomestic,lastmonthdomestic,currmonthforeign,lastmonthforeign,budget,relbudget,changeamt,changerate,sort", (QFilter[])new QFilter[]{orgViewFilter, orgFilter, currencyFilter, dateFilter}, (String)"sort,bizdate desc");
        return existSumData;
    }

    private List<Date> getfirstDayOfMonthsByQueryDate(Date queryDate) {
        ArrayList<Date> firstDayOfMonthList = new ArrayList<Date>(4);
        for (int i = 0; i <= 3; ++i) {
            firstDayOfMonthList.add(DateUtils.getFirstDateOfAnyMonth((Date)queryDate, (int)(-i)));
        }
        return firstDayOfMonthList;
    }

    private List<Map<String, Object>> loadRptSumDataFromPlugin(DynamicObject orgView, DynamicObject org, Date queryDate, DynamicObject currency, String amountUnit, Date curyyMM) {
        if (curyyMM.before(new Date())) {
            SynthsisSumDataHelper sumDataHelper = new SynthsisSumDataHelper(orgView, org, null, queryDate);
            sumDataHelper.refreshSumData();
        }
        DynamicObject[] existSumData = this.getExistSumData(orgView, org, queryDate);
        return this.loadRptSumDataFromDB(orgView, org, queryDate, currency, amountUnit, existSumData);
    }

    private List<Map<String, Object>> loadRptSumDataFromDB(DynamicObject orgView, DynamicObject org, Date queryDate, DynamicObject currency, String amountUnit, DynamicObject[] existSumData) {
        Date bizDate = queryDate;
        for (DynamicObject sumData : existSumData) {
            String project = sumData.getString("project");
            SynthesisProjectEnum projectEnum = SynthesisProjectEnum.getEnumByValue((String)project);
            if (SynthesisProjectEnum.ADR != projectEnum) continue;
            BigDecimal adrBigDecimal = sumData.getBigDecimal("currmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP);
            if (adrBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                bizDate = sumData.getDate("bizdate");
                break;
            }
            bizDate = null;
        }
        ArrayList<Map<String, Object>> synthesisEntryList = new ArrayList<Map<String, Object>>(10);
        block8: for (DynamicObject sumData : existSumData) {
            if (bizDate == null) {
                bizDate = sumData.getDate("bizdate");
            }
            if (bizDate.compareTo(sumData.getDate("bizdate")) != 0) continue;
            String project = sumData.getString("project");
            Long sumCurrencyId = sumData.getDynamicObject("currency").getLong("id");
            SynthesisProjectEnum projectEnum = SynthesisProjectEnum.getEnumByValue((String)project);
            switch (projectEnum) {
                case FD: {
                    synthesisEntryList.add(this.createFundEntry(sumData, sumCurrencyId, false, orgView, queryDate, currency, amountUnit));
                    continue block8;
                }
                case PR: 
                case FC: {
                    synthesisEntryList.add(this.createProfitRateEntry(sumData));
                    continue block8;
                }
                case IDA: {
                    synthesisEntryList.add(this.createFundEntry(sumData, sumCurrencyId, true, orgView, queryDate, currency, amountUnit));
                    continue block8;
                }
                case NA: 
                case EA: {
                    synthesisEntryList.add(this.createNetAssetsEntry(sumData, sumCurrencyId, orgView, queryDate, currency, amountUnit));
                    continue block8;
                }
                case ADR: 
                case IDR: 
                case IDER: {
                    synthesisEntryList.add(this.createAssetsDebtRateEntry(sumData));
                    continue block8;
                }
            }
        }
        return synthesisEntryList;
    }

    private Map<String, Object> createFundEntry(DynamicObject sumData, Long sumCurrencyId, boolean containsBudget, DynamicObject orgView, Date queryDate, DynamicObject currency, String amountUnit) {
        HashMap<String, Object> fundEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        fundEntry.put("project", project);
        if (containsBudget) {
            fundEntry.put("budget", this.tranRate(sumData.getBigDecimal("budget"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
            fundEntry.put("relbudget", this.tranRate(sumData.getBigDecimal("relbudget"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        } else {
            fundEntry.put("budget", "--");
            fundEntry.put("relbudget", "--");
        }
        fundEntry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        fundEntry.put("currmonthtotal", this.tranRate(sumData.getBigDecimal("currmonthtotal"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthtotal", this.tranRate(sumData.getBigDecimal("lastmonthtotal"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("currmonthdomestic", this.tranRate(sumData.getBigDecimal("currmonthdomestic"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthdomestic", this.tranRate(sumData.getBigDecimal("lastmonthdomestic"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("currmonthforeign", this.tranRate(sumData.getBigDecimal("currmonthforeign"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("lastmonthforeign", this.tranRate(sumData.getBigDecimal("lastmonthforeign"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        fundEntry.put("changeamt", this.tranRate(sumData.getBigDecimal("changeamt"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        return fundEntry;
    }

    private Map<String, Object> createProfitRateEntry(DynamicObject sumData) {
        HashMap<String, Object> profitRateEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        profitRateEntry.put("project", project);
        profitRateEntry.put("budget", "--");
        profitRateEntry.put("relbudget", "--");
        profitRateEntry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthtotal", sumData.getBigDecimal("currmonthtotal").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthtotal", sumData.getBigDecimal("lastmonthtotal").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthdomestic", sumData.getBigDecimal("currmonthdomestic").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthdomestic", sumData.getBigDecimal("lastmonthdomestic").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthforeign", sumData.getBigDecimal("currmonthforeign").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthforeign", sumData.getBigDecimal("lastmonthforeign").setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("changeamt", sumData.getBigDecimal("changeamt").setScale(2, RoundingMode.HALF_UP) + "%");
        return profitRateEntry;
    }

    private Map<String, Object> createNetAssetsEntry(DynamicObject sumData, Long sumCurrencyId, DynamicObject orgView, Date queryDate, DynamicObject currency, String amountUnit) {
        HashMap<String, Object> entry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        entry.put("project", project);
        entry.put("currmonthdomestic", "--");
        entry.put("lastmonthdomestic", "--");
        entry.put("currmonthforeign", "--");
        entry.put("lastmonthforeign", "--");
        entry.put("budget", this.tranRate(sumData.getBigDecimal("budget"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        entry.put("relbudget", this.tranRate(sumData.getBigDecimal("relbudget"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        entry.put("changerate", sumData.getBigDecimal("changerate").setScale(2, RoundingMode.HALF_UP) + "%");
        entry.put("currmonthtotal", this.tranRate(sumData.getBigDecimal("currmonthtotal"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        entry.put("lastmonthtotal", this.tranRate(sumData.getBigDecimal("lastmonthtotal"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        entry.put("changeamt", this.tranRate(sumData.getBigDecimal("changeamt"), sumCurrencyId, orgView, queryDate, currency, amountUnit).setScale(2, RoundingMode.HALF_UP));
        return entry;
    }

    private String getExtendProjectName(String projectValue) {
        PluginProxy pluginProxy = PluginProxy.create(ISynthesisLoadDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.synthesis.ISynthesisLoadDataInterface");
        List lists = pluginProxy.callReplace(p -> p.getExtendProjectName(projectValue));
        if (EmptyUtil.isNoEmpty((Object)lists) && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (String)lists.get(0);
        }
        return SynthesisProjectEnum.getName((String)projectValue);
    }

    private BigDecimal tranRate(BigDecimal amt, Long fromCurrencyId, DynamicObject orgView, Date queryDate, DynamicObject currency, String amountUnit) {
        BigDecimal rate = this.getRate(fromCurrencyId, orgView, queryDate, currency);
        BigDecimal tranRateAmt = amt.multiply(rate);
        BigDecimal tranUnitAmt = tranRateAmt.divide(new BigDecimal(amountUnit));
        return tranUnitAmt;
    }

    private BigDecimal getRate(Long fromCurrencyId, DynamicObject orgView, Date queryDate, DynamicObject currency) {
        Long orgViewId = orgView.getLong("id");
        String key = fromCurrencyId + orgViewId + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd");
        if (this.rateCache.containsKey(key)) {
            return this.rateCache.get(key);
        }
        String orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgViewId);
        BigDecimal rate = BigDecimal.ONE;
        if (EmptyUtil.isNoEmpty((String)orgRootId)) {
            long rootOrgId = Long.parseLong(orgRootId);
            Long tarCurrencyId = currency.getLong("id");
            if (fromCurrencyId.equals(tarCurrencyId)) {
                rate = BigDecimal.ONE;
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)tarCurrencyId, (long)rootOrgId, (Date)queryDate);
                if (rate == null) {
                    rate = BigDecimal.ONE;
                }
            }
        }
        this.rateCache.put(key, rate);
        return rate;
    }

    private Map<String, Object> createAssetsDebtRateEntry(DynamicObject sumData) {
        HashMap<String, Object> profitRateEntry = new HashMap<String, Object>(16);
        String project = this.getExtendProjectName(sumData.getString("project"));
        profitRateEntry.put("project", project);
        profitRateEntry.put("currmonthdomestic", "--");
        profitRateEntry.put("lastmonthdomestic", "--");
        profitRateEntry.put("currmonthforeign", "--");
        profitRateEntry.put("lastmonthforeign", "--");
        profitRateEntry.put("changerate", sumData.getBigDecimal("changerate").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("currmonthtotal", sumData.getBigDecimal("currmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("lastmonthtotal", sumData.getBigDecimal("lastmonthtotal").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("budget", sumData.getBigDecimal("budget").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("relbudget", sumData.getBigDecimal("relbudget").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        profitRateEntry.put("changeamt", sumData.getBigDecimal("changeamt").multiply(Constants.ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP) + "%");
        return profitRateEntry;
    }
}

