/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.business.ccr;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.enums.FundFocusRateEnum;
import kd.tmc.tda.common.helper.CtrlConditionHelper;

public class FundConcentrateSetSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("orgview");
        sic.add("statisticaltype");
        sic.add("applycondition_tag");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObjectCollection config = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entry");
            String groupCondition = null;
            String fundCondition = null;
            for (DynamicObject entry : config) {
                String statisticalType = entry.getString("statisticaltype");
                String applyCondition = entry.getString("applycondition_tag");
                if (FundFocusRateEnum.GROUP_COLLECTION.getNumber().equals(statisticalType)) {
                    groupCondition = applyCondition;
                }
                if (!FundFocusRateEnum.FUND_CASH.getNumber().equals(statisticalType)) continue;
                fundCondition = applyCondition;
            }
            QFilter groupFilter = CtrlConditionHelper.getFilterFromTag((String)"bd_accountbanks", groupCondition);
            if (groupFilter == null) continue;
            Long orgViewId = extendedDataEntity.getDataEntity().getDynamicObject("orgview").getLong("id");
            List allViewOrgs = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)orgViewId);
            QFilter filter = new QFilter("company", "in", (Object)allViewOrgs);
            Set<String> fundBankAcct = FundConcentrateSetSaveValidator.getBankAcctSet(filter);
            filter.and(groupFilter);
            Set<String> addGroupBankAcct = FundConcentrateSetSaveValidator.getGroupBankAcctSet(filter);
            QFilter fundFilter = CtrlConditionHelper.getFilterFromTag((String)"bd_accountbanks", (String)fundCondition);
            if (fundFilter != null) {
                QFilter ffilter = new QFilter("company", "in", (Object)allViewOrgs);
                ffilter.and(fundFilter);
                Set<String> acctIds = FundConcentrateSetSaveValidator.getBankAcctSet(ffilter);
                fundBankAcct.removeAll(acctIds);
            }
            addGroupBankAcct.removeAll(fundBankAcct);
            if (!CollectionUtils.isNotEmpty(addGroupBankAcct)) continue;
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u56e2\u5f52\u96c6\u8d44\u91d1\u589e\u52a0\u7684\u8d26\u6237\u4e0d\u5728\u8d44\u91d1\u603b\u989d\u5bf9\u5e94\u8d26\u6237\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff1a%s\u3002", (String)"FundConcentrateSetSaveValidator_2", (String)"tmc-tda-business", (Object[])new Object[0]), addGroupBankAcct);
            this.addErrorMessage(extendedDataEntity, message);
        }
    }

    private static Set<String> getBankAcctSet(QFilter filter) {
        DynamicObjectCollection bankActs = QueryServiceHelper.query((String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])filter.toArray());
        return bankActs.stream().map(e -> e.getString("bankaccountnumber")).collect(Collectors.toSet());
    }

    private static Set<String> getGroupBankAcctSet(QFilter filter) {
        DynamicObjectCollection bankActs = QueryServiceHelper.query((String)"bd_accountbanks", (String)"bankaccountnumber,finorgtype", (QFilter[])filter.toArray());
        Map typeAcctMap = bankActs.stream().collect(Collectors.groupingBy(e -> e.getString("finorgtype"), Collectors.mapping(e -> e.getString("bankaccountnumber"), Collectors.toSet())));
        Set finCompList = typeAcctMap.get(FinOrgTypeEnum.FINCOMP.getValue());
        if (CollectionUtils.isNotEmpty(finCompList)) {
            String showStr = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u56e2\u5f52\u96c6\u8d44\u91d1\u589e\u52a0\u7684\u8d26\u6237\u542b\u6709\u8d22\u53f8\u5f52\u96c6\u8d44\u91d1\u5bf9\u5e94\u8d26\u6237\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff1a%s\u3002", (String)"FundConcentrateSetSaveValidator_1", (String)"tmc-tda-business", (Object[])new Object[0]), finCompList);
            throw new KDBizException(showStr);
        }
        return bankActs.stream().map(e -> e.getString("bankaccountnumber")).collect(Collectors.toSet());
    }
}

