/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.business.synthsis;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SynthsisSumDataHelper;

public class SynthsisRefreshDataService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("orgview");
        sic.add("org");
        sic.add("currency");
        sic.add("bizdate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        dataEntities = (DynamicObject[])Arrays.stream(dataEntities).filter(s -> s.getDynamicObject("orgview") != null && s.getDynamicObject("org") != null).toArray(DynamicObject[]::new);
        Map<Object, List<DynamicObject>> groupMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(v -> v.getDynamicObject("orgview").getPkValue() + "-" + v.getDynamicObject("org").getPkValue() + "-" + DateUtils.formatString((Date)v.getDate("bizdate"), (String)"yyyy-MM-dd")));
        for (Map.Entry<Object, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> sumDataList = entry.getValue();
            DynamicObject orgView = sumDataList.get(0).getDynamicObject("orgview");
            DynamicObject org = sumDataList.get(0).getDynamicObject("org");
            DynamicObject currency = sumDataList.get(0).getDynamicObject("currency");
            Date bizDate = sumDataList.get(0).getDate("bizdate");
            SynthsisSumDataHelper sumDataHelper = new SynthsisSumDataHelper(orgView, org, currency, bizDate);
            sumDataHelper.refreshSumData();
        }
    }
}

