/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.MQ;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.BatchTaskStatusSynHelper;

public class FinCostScheduleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(FinCostScheduleConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        long begintime = System.currentTimeMillis();
        Timestamp thisBatchBeginTime = DateUtils.getCurrentTime();
        logger.info("FinCostScheduleConsumer : " + JSON.toJSONString((Object)message));
        List loanBillList = (List)message;
        Set loanBillIds = loanBillList.stream().map(m -> (Long)m.get("loanbillid")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("sourcebillid", "in", loanBillIds);
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet loanInt = QueryServiceHelper.queryDataSet((String)"FinCostScheduleConsumer.getIntBillInfo", (String)"cfm_interestbill", (String)"id,sourcebillid,entrys.inststartdate begindate,entrys.instenddate enddate,entrys.instprincipalamt principle,entrys.rate rate,entrys.instdays instdays,entrys.ratetrandays ratetrandays,entrys.instamt instamt,entrys.instctg instctg", (QFilter[])qfilter.toArray(), null);
        ArrayList<Object> loanIntList = new ArrayList<Object>(10);
        for (Row row : loanInt) {
            if (row.getBigDecimal("rate") == null || row.getBigDecimal("rate").compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap tempMap = new HashMap(16);
            tempMap.put("loanbillid", row.getLong("sourcebillid"));
            tempMap.put("intstartdate", row.getDate("begindate"));
            tempMap.put("intenddate", row.getDate("enddate"));
            tempMap.put("instdays", row.getInteger("instdays"));
            tempMap.put("intprinciple", row.getBigDecimal("principle"));
            tempMap.put("intrate", row.getBigDecimal("rate"));
            tempMap.put("ratetrandays", row.getInteger("ratetrandays"));
            tempMap.put("intamount", row.getBigDecimal("instamt"));
            tempMap.put("inttype", row.getString("instctg"));
            tempMap.put("type", "intbill");
            loanIntList.add(tempMap);
        }
        Map<Long, List<Map>> groupLoanInt = loanIntList.stream().collect(Collectors.groupingBy(l -> (Long)l.get("loanbillid")));
        ArrayList<DynamicObject> newIntInfos = new ArrayList<DynamicObject>(10);
        for (Map loanInfo : loanBillList) {
            long starttime = System.currentTimeMillis();
            Long loanbillid = (Long)loanInfo.get("loanbillid");
            Date startintdate = (Date)loanInfo.get("begindate");
            Date expiredate = (Date)loanInfo.get("enddate");
            Boolean clearflag = (Boolean)loanInfo.get("clearflag");
            try {
                List<Map<String, Object>> intBillInfos = FinCostScheduleConsumer.getIntBillInfo(loanbillid, startintdate, expiredate);
                List<Map> tempIntList = groupLoanInt.get(loanbillid);
                if (EmptyUtil.isNoEmpty(tempIntList)) {
                    intBillInfos.addAll(tempIntList);
                }
                if (EmptyUtil.isNoEmpty(intBillInfos)) {
                    this.tranToDynamicObject(newIntInfos, intBillInfos, clearflag);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Object)e);
                logger.info(loanbillid + "\u5904\u7406\u5229\u606f\u8ba1\u7b97\u9519\u8bef" + e.getMessage());
            }
            logger.info(loanbillid + "\u5229\u606f\u8ba1\u7b97\u8017\u65f6\uff1a" + (System.currentTimeMillis() - starttime));
        }
        if (EmptyUtil.isNoEmpty(newIntInfos)) {
            QFilter deleteFilter = new QFilter("loanbillid", "in", loanBillIds);
            DeleteServiceHelper.delete((String)"tda_loanbillintinfo", (QFilter[])deleteFilter.toArray());
            SaveServiceHelper.save((DynamicObject[])newIntInfos.toArray(new DynamicObject[0]));
        }
        logger.info("\u5355\u6279\u8c03\u5ea6\u4efb\u52a1\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begintime));
        try {
            acker.ack(messageId);
            String taskNum = "";
            if (EmptyUtil.isNoEmpty((Object)loanBillList)) {
                taskNum = (String)((Map)loanBillList.get(0)).get("tasknum");
                BatchTaskStatusSynHelper.singleBatchFinish((String)taskNum, (Date)thisBatchBeginTime);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void tranToDynamicObject(List<DynamicObject> newIntInfos, List<Map<String, Object>> intBillInfos, Boolean clearflag) {
        for (Map<String, Object> intBillInfo : intBillInfos) {
            DynamicObject tdaIntInfo = BusinessDataServiceHelper.newDynamicObject((String)"tda_loanbillintinfo");
            tdaIntInfo.set("loanbillid", intBillInfo.get("loanbillid"));
            tdaIntInfo.set("intstartdate", intBillInfo.get("intstartdate"));
            tdaIntInfo.set("intenddate", intBillInfo.get("intenddate"));
            tdaIntInfo.set("instdays", intBillInfo.get("instdays"));
            tdaIntInfo.set("intprinciple", intBillInfo.get("intprinciple"));
            tdaIntInfo.set("intrate", intBillInfo.get("intrate"));
            tdaIntInfo.set("ratetrandays", intBillInfo.get("ratetrandays"));
            tdaIntInfo.set("intamount", intBillInfo.get("intamount"));
            tdaIntInfo.set("type", intBillInfo.get("type"));
            tdaIntInfo.set("inttype", intBillInfo.get("inttype"));
            tdaIntInfo.set("isclear", (Object)clearflag);
            tdaIntInfo.set("createdate", (Object)DateUtils.getCurrentTime());
            tdaIntInfo.set("modifydate", (Object)DateUtils.getCurrentTime());
            newIntInfos.add(tdaIntInfo);
        }
    }

    public static List<Map<String, Object>> getIntBillInfo(Long loanBillId, Date startDate, Date endDate) {
        ArrayList<Map<String, Object>> intBillInfos;
        block5: {
            Object calResult;
            block4: {
                intBillInfos = new ArrayList<Map<String, Object>>(10);
                Date realCalEndDate = endDate.compareTo(DateUtils.getCurrentDate()) >= 0 ? endDate : DateUtils.getCurrentDate();
                calResult = DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)TmcAppEnum.CFM.getValue(), (String)"intCalcService", (String)"callLoanInt", (Object[])new Object[]{loanBillId, startDate, realCalEndDate});
                if (calResult == null) {
                    return intBillInfos;
                }
                if (!(calResult instanceof Map)) break block4;
                logger.info("getIntBillInfo\u5fae\u670d\u52a1\u7ed3\u679cMap");
                Map result = (Map)calResult;
                List detail = (List)result.get("details");
                if (!EmptyUtil.isNoEmpty((Object)detail)) break block5;
                for (IntBillDetailInfo intBillDetailInfo : detail) {
                    if (intBillDetailInfo.getRate() == null || intBillDetailInfo.getRate().compareTo(BigDecimal.ZERO) == 0 || intBillDetailInfo.getPrinciple() == null || intBillDetailInfo.getPrinciple().compareTo(BigDecimal.ZERO) == 0) continue;
                    HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                    tempMap.put("loanbillid", loanBillId);
                    tempMap.put("intstartdate", intBillDetailInfo.getBeginDate());
                    tempMap.put("intenddate", intBillDetailInfo.getEndDate());
                    tempMap.put("instdays", intBillDetailInfo.getDays());
                    tempMap.put("intprinciple", intBillDetailInfo.getPrinciple());
                    tempMap.put("intrate", intBillDetailInfo.getRate());
                    tempMap.put("ratetrandays", intBillDetailInfo.getBasisDay());
                    tempMap.put("intamount", intBillDetailInfo.getAmount());
                    tempMap.put("inttype", intBillDetailInfo.getIntType().getValue());
                    tempMap.put("type", "mservice");
                    intBillInfos.add(tempMap);
                }
                break block5;
            }
            logger.info("getIntBillInfo\u5fae\u670d\u52a1\u7ed3\u679cIntBillInfo");
            IntBillExtInfo result = (IntBillExtInfo)JSON.parseObject((String)JSON.toJSONString((Object)calResult), IntBillExtInfo.class);
            List detail = result.getExtDetails();
            if (EmptyUtil.isNoEmpty((Object)detail)) {
                for (IntBillDetailExtInfo intBillDetailInfo : detail) {
                    if (intBillDetailInfo.getTotalRate() == null || intBillDetailInfo.getTotalRate().compareTo(BigDecimal.ZERO) == 0 || intBillDetailInfo.getPrinciple() == null || intBillDetailInfo.getPrinciple().compareTo(BigDecimal.ZERO) == 0) continue;
                    HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                    tempMap.put("loanbillid", loanBillId);
                    tempMap.put("intstartdate", intBillDetailInfo.getBeginDate());
                    tempMap.put("intenddate", intBillDetailInfo.getEndDate());
                    tempMap.put("instdays", intBillDetailInfo.getDays());
                    tempMap.put("intprinciple", intBillDetailInfo.getPrinciple());
                    tempMap.put("intrate", intBillDetailInfo.getTotalRate());
                    tempMap.put("ratetrandays", intBillDetailInfo.getBasisDay());
                    tempMap.put("intamount", intBillDetailInfo.getTotalInt());
                    tempMap.put("inttype", intBillDetailInfo.getIntType().getValue());
                    tempMap.put("type", "mservice");
                    intBillInfos.add(tempMap);
                }
            }
        }
        return intBillInfos;
    }
}

