/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.arap;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractArapSummaryService {
    private static final String AR_AP_BILLL_FIELD = "billno, org.id as orgid, currency.id as currencyid, unsettleamount, unsettleamount as amount, asstact as custsuppid, TO_CHAR(duedate, 'yyyy-MM-dd') as duedate, 1 as count";
    private static final String SETTLE_FIELD_MAIN = "billno, totalsettleamt, entry.billnum as assistbillno, entry.settleamt as assistsettleamt, settlerelation";
    private static final String CUSTSUPP_FIELD = "id,case when internal_company = 0 then 'outside' else 'inside' end as custsupptype, name as custsuppname";

    public Pair<Map<String, Integer>, DataSet> genArapDataSetByBillType(Date dealDate) {
        String entity = this.getArApEntityNumber();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("asstacttype", "=", (Object)this.getAsstactType());
        this.setArapFilter(qFilter);
        Date maxMonthDate = this.getMaxMonthDateAndSetBizDateFilter(qFilter, dealDate);
        DataSet allBills = QueryServiceHelper.queryDataSet((String)(AbstractArapSummaryService.class.getName() + entity), (String)entity, (String)AR_AP_BILLL_FIELD, (QFilter[])qFilter.toArray(), null);
        if (allBills.copy().isEmpty()) {
            return null;
        }
        allBills = allBills.addField("TO_DATE('" + DateUtils.formatString((Date)maxMonthDate, (String)"yyyy-MM-dd") + "' , '" + "yyyy-MM-dd" + "')", "querydate");
        QFilter settlecCommonFilter = this.getSettleFilter(maxMonthDate);
        String settleMainEntity = this.getSettleMainEntity();
        DataSet settleMainBills = QueryServiceHelper.queryDataSet((String)(AbstractArapSummaryService.class.getName() + settleMainEntity), (String)settleMainEntity, (String)SETTLE_FIELD_MAIN, (QFilter[])settlecCommonFilter.toArray(), null);
        if (!settleMainBills.copy().isEmpty()) {
            DataSet mainDs = settleMainBills.copy().select(true, new String[]{"billno", "totalsettleamt"});
            allBills = allBills.leftJoin(mainDs).on("billno", "billno").select(allBills.getRowMeta().getFieldNames(), new String[]{"totalsettleamt"}).finish().updateField("amount", "amount+totalsettleamt");
            DataSet assistDs = settleMainBills.groupBy(new String[]{"assistbillno"}).sum("assistsettleamt").finish();
            if (!assistDs.copy().isEmpty()) {
                allBills = allBills.leftJoin(assistDs).on("billno", "assistbillno").select(allBills.getRowMeta().getFieldNames(), new String[]{"assistsettleamt"}).finish().updateField("amount", "amount+assistsettleamt");
            }
        }
        allBills = allBills.addField("DATEDIF(duedate, querydate, 'D')", "duedays");
        DynamicObject aging = this.getAccrualAging();
        DynamicObjectCollection entrys = aging.getDynamicObjectCollection("entry");
        StringBuilder agingBuilder = new StringBuilder();
        HashMap<Object, Integer> seqMap = new HashMap<Object, Integer>(16);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String section = entry.getString("e_section");
            int startDay = entry.getInt("e_startday");
            int endDay = entry.getInt("e_endday");
            if (i == 0) {
                agingBuilder.append("case ");
            }
            if (startDay == 0) {
                agingBuilder.append(" when duedays <= ");
                agingBuilder.append(endDay);
            } else {
                agingBuilder.append(" when duedays >= ");
                agingBuilder.append(startDay);
                if (EmptyUtil.isNoEmpty((Integer)endDay)) {
                    agingBuilder.append(" and duedays <= ");
                    agingBuilder.append(endDay);
                }
            }
            agingBuilder.append(" then '");
            agingBuilder.append(section);
            agingBuilder.append("' ");
            if (i == entrys.size() - 1) {
                agingBuilder.append(" end");
            }
            seqMap.put(section, i + 1);
        }
        allBills = allBills.addField(agingBuilder.toString(), "aging");
        DataSet groupDs = allBills.groupBy(new String[]{"orgid", "currencyid", "custsuppid", "aging"}).sum("amount").sum("count").finish();
        ArrayList<Long> custsuppIds = new ArrayList<Long>(10);
        for (Row row : groupDs.copy()) {
            custsuppIds.add(row.getLong("custsuppid"));
        }
        QFilter custSuppFilter = new QFilter("id", "in", custsuppIds);
        DataSet custSuppDs = QueryServiceHelper.queryDataSet((String)(AbstractArapSummaryService.class.getName() + "_custsupp"), (String)this.getCustSuppEntity(), (String)CUSTSUPP_FIELD, (QFilter[])custSuppFilter.toArray(), null);
        DataSet join = groupDs.join(custSuppDs).on("custsuppid", "id").select(groupDs.getRowMeta().getFieldNames(), new String[]{"custsupptype", "custsuppname"}).finish();
        return Pair.of(seqMap, (Object)join);
    }

    private Date getMaxMonthDateAndSetBizDateFilter(QFilter qFilter, Date dealDate) {
        Date lastMonth = DateUtils.getLastMonth((Date)dealDate, (int)1);
        Date maxMonthDate = DateUtils.getMaxMonthDate((Date)lastMonth);
        qFilter.and("bizdate", "<=", (Object)maxMonthDate);
        return maxMonthDate;
    }

    private QFilter getSettleFilter(Date maxMonthDate) {
        QFilter settleFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        settleFilter.and("settledate", ">", (Object)maxMonthDate);
        return settleFilter;
    }

    private DynamicObject getAccrualAging() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("type", "=", (Object)this.getAgingType());
        return TmcDataServiceHelper.loadSingleFromCache((String)"tda_accrualaging", (QFilter[])qFilter.toArray());
    }

    protected abstract String getArApEntityNumber();

    protected abstract void setArapFilter(QFilter var1);

    protected abstract String getSettleMainEntity();

    protected abstract String getAsstactType();

    protected abstract String getAgingType();

    protected abstract String getCustSuppEntity();
}

