/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.arap;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.mservice.arap.AbstractArapSummaryService;

public abstract class AbstractPayRecSummaryService {
    private static final String PAY_BILLL_FIELD = "billno, org.id as orgid, currency.id as currencyid, entry.e_unsettledamt as unsettleamount, entry.e_unsettledamt as amount, itempayee as custsuppid, 1 as count";
    private static final String REC_BILLL_FIELD = "billno, org.id as orgid, currency.id as currencyid, entry.e_unsettledamt as unsettleamount, entry.e_unsettledamt as amount, itempayer as custsuppid, 1 as count";
    private static final String SETTLE_FIELD_MAIN = "billno, totalsettleamt, entry.billnum as assistbillno, entry.settleamt as assistsettleamt, settlerelation";
    private static final String CUSTSUPP_FIELD = "id,case when internal_company = 0 then 'outside' else 'inside' end as custsupptype, name as custsuppname";

    public DataSet genPayRecDataSetByBillType(Date dealDate) {
        String payeeType;
        String selectField;
        String entity = this.getPayRecEntityNumber();
        QFilter qFilter = new QFilter("billstatus", "in", (Object)this.getBillStatus());
        if ("cas_paybill".equals(entity)) {
            selectField = PAY_BILLL_FIELD;
            qFilter.and("paymenttype.biztype", "=", (Object)"202");
            payeeType = "payeetype";
        } else {
            selectField = REC_BILLL_FIELD;
            qFilter.and("receivingtype.biztype", "=", (Object)"101");
            payeeType = "payertype";
        }
        qFilter.and(payeeType, "=", (Object)this.getPayeeType());
        Date maxMonthDate = this.getMaxMonthDateAndSetBizDateFilter(qFilter, dealDate);
        DataSet allBills = QueryServiceHelper.queryDataSet((String)(AbstractPayRecSummaryService.class.getName() + entity), (String)entity, (String)selectField, (QFilter[])qFilter.toArray(), null);
        if (allBills.copy().isEmpty()) {
            return null;
        }
        allBills = allBills.groupBy(new String[]{"billno", "orgid", "currencyid", "custsuppid", "count"}).sum("unsettleamount").sum("amount").finish();
        QFilter settlecCommonFilter = this.getSettleFilter(maxMonthDate);
        String settleMainEntity = this.getSettleMainEntity();
        DataSet settleMainBills = QueryServiceHelper.queryDataSet((String)(AbstractArapSummaryService.class.getName() + settleMainEntity), (String)settleMainEntity, (String)SETTLE_FIELD_MAIN, (QFilter[])settlecCommonFilter.toArray(), null);
        if (!settleMainBills.copy().isEmpty()) {
            DataSet mainDs = settleMainBills.copy().select(true, new String[]{"billno", "totalsettleamt"});
            allBills = allBills.leftJoin(mainDs).on("billno", "billno").select(allBills.getRowMeta().getFieldNames(), new String[]{"totalsettleamt"}).finish().updateField("amount", "amount+totalsettleamt");
            DataSet assistDs = settleMainBills.groupBy(new String[]{"assistbillno"}).sum("assistsettleamt").finish();
            if (!assistDs.copy().isEmpty()) {
                allBills = allBills.leftJoin(assistDs).on("billno", "assistbillno").select(allBills.getRowMeta().getFieldNames(), new String[]{"assistsettleamt"}).finish().updateField("amount", "amount+assistsettleamt");
            }
        }
        DataSet groupDs = allBills.groupBy(new String[]{"orgid", "currencyid", "custsuppid"}).sum("amount").sum("count").finish();
        ArrayList<Long> custsuppIds = new ArrayList<Long>(10);
        for (Row row : groupDs.copy()) {
            custsuppIds.add(row.getLong("custsuppid"));
        }
        QFilter custSuppFilter = new QFilter("id", "in", custsuppIds);
        DataSet custSuppDs = QueryServiceHelper.queryDataSet((String)(AbstractArapSummaryService.class.getName() + "_custsupp"), (String)this.getCustSuppEntity(), (String)CUSTSUPP_FIELD, (QFilter[])custSuppFilter.toArray(), null);
        DataSet join = groupDs.join(custSuppDs).on("custsuppid", "id").select(groupDs.getRowMeta().getFieldNames(), new String[]{"custsupptype", "custsuppname"}).finish();
        return join;
    }

    private Date getMaxMonthDateAndSetBizDateFilter(QFilter qFilter, Date dealDate) {
        Date lastMonth = DateUtils.getLastMonth((Date)dealDate, (int)1);
        Date maxMonthDate = DateUtils.getMaxMonthDate((Date)lastMonth);
        qFilter.and("bizdate", "<=", (Object)maxMonthDate);
        return maxMonthDate;
    }

    private QFilter getSettleFilter(Date maxMonthDate) {
        QFilter settleFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        settleFilter.and("settledate", ">", (Object)maxMonthDate);
        return settleFilter;
    }

    protected abstract String getPayRecEntityNumber();

    protected abstract String getPayeeType();

    protected abstract String getSettleMainEntity();

    protected abstract String getCustSuppEntity();

    protected abstract String[] getBillStatus();
}

