/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.detail;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.SysParamHelper;

public class TransDetailSummaryService {
    private static final Log logger = LogFactory.getLog(TransDetailSummaryService.class);

    public void summary(Long orgId, String bizDate) {
        if (!this.isOpenSettle()) {
            return;
        }
        logger.info("\u4ea4\u6613\u660e\u7ec6\u6c47\u603b\u65e5\u5fd7\u8868\u4fdd\u5b58\u6570\u636e\uff0corgId :" + orgId + " bizDate: " + bizDate);
        DynamicObject transDetailLog = TmcDataServiceHelper.newDynamicObject((String)"tda_transdetaillog");
        transDetailLog.set("org", (Object)orgId);
        Date formatBizDate = DateUtils.stringToDate((String)bizDate, (String)"yyyy-MM-dd");
        transDetailLog.set("bizdate", (Object)formatBizDate);
        transDetailLog.set("isfinish", (Object)false);
        transDetailLog.set("billno", (Object)(orgId + "-" + DateUtils.formatString((Date)DateUtils.getFirstDayOfMonth((Date)formatBizDate), (String)"yyyyMM")));
        transDetailLog.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        transDetailLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        transDetailLog.set("createtime", (Object)DateUtils.getCurrentTime());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{transDetailLog});
    }

    public void batchSummary(List<Map<String, Object>> params) {
        if (!this.isOpenSettle()) {
            return;
        }
        for (Map<String, Object> param : params) {
            this.summary((Long)param.get("orgId"), (String)param.get("bizDate"));
        }
    }

    private boolean isOpenSettle() {
        return SysParamHelper.isOpenSettle();
    }
}

