/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.detail;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.tmc.tda.extpoint.transdetail.ITransDetailGetDataInterface;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SysParamHelper;

public class TransDetailTaskSummaryService {
    private static final Log logger = LogFactory.getLog(TransDetailTaskSummaryService.class);

    public void summary(Long orgId, Date bizDate) {
        boolean isOpenSettle = SysParamHelper.isOpenSettle();
        if (!isOpenSettle) {
            logger.info("\u7ed3\u7b97\u7ba1\u7406\u53c2\u6570\u672a\u5f00\u542f\uff0c\u4ea4\u6613\u660e\u7ec6\u8c03\u5ea6\u4efb\u52a1\u5df2\u7ed3\u675f\u3002");
            return;
        }
        logger.info("\u751f\u6210\u4ea4\u6613\u660e\u7ec6\u6c47\u603b\u6570\u636estart... orgId :" + orgId, (Object)(" bizDate: " + bizDate));
        QFilter filter = new QFilter("company.id", "=", (Object)orgId);
        filter = filter.and(new QFilter("bizdate", ">=", (Object)bizDate));
        filter = filter.and(new QFilter("bizdate", "<", (Object)DateUtils.getFirstDateOfNextMonth((Date)bizDate)));
        filter.and("bank.finorgtype.type", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        filter.and("bank.id", "!=", (Object)0);
        filter.and(this.getExtendFilter());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.tmc.tda.mservice.detail.TransDetailTaskSummaryService.summary", (String)"bei_transdetail", (String)"company.id,currency.id,bizdate,creditamount,debitamount,case when bank.country.twocountrycode = 'CN' then 'domestic' else case when bank.country.threecountrycode = 'CHN' then 'domestic' else case when bank.country = 0 or (bank.country.twocountrycode = ' ' and bank.country.threecountrycode = ' ') then 'domestic' else 'overseas' end end end as area", (QFilter[])filter.toArray(), null);
        ds = ds.filter("(creditamount <> 0 and debitamount = 0) or (debitamount <> 0 and creditamount = 0)");
        ds = ds.addFields(new String[]{"case when creditamount <> 0 and debitamount = 0 then 1 else 0 end", "case when debitamount <> 0 and creditamount = 0 then 1 else 0 end"}, new String[]{"creditcount", "debitcount"});
        DataSet groupDs = ds.groupBy(new String[]{"company.id", "currency.id", "area"}).sum("creditamount", "creditamounts").sum("debitamount", "debitamounts").sum("creditcount").sum("debitcount").finish();
        this.deleteMonthSummary(orgId, bizDate);
        Iterator groupIter = groupDs.iterator();
        DynamicObject monthSummary = this.getMonthSummary(orgId, bizDate);
        boolean hasEntry = false;
        while (groupIter.hasNext()) {
            Row row = groupDs.next();
            String area = row.getString("area");
            Long currencyId = row.getLong("currency.id");
            DynamicObject r1 = this.getExsitEntry(monthSummary, row, area);
            r1.set("area", (Object)area);
            r1.set("currency", (Object)currencyId);
            r1.set("creditamount", (Object)row.getBigDecimal("creditamounts"));
            r1.set("debitamount", (Object)row.getBigDecimal("debitamounts"));
            int creditCount = row.getInteger("creditCount");
            int debitCount = row.getInteger("debitCount");
            r1.set("creditcount", (Object)creditCount);
            r1.set("debitcount", (Object)debitCount);
            hasEntry = true;
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)monthSummary) && hasEntry) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{monthSummary});
        }
        groupDs.close();
        ds.close();
        logger.info("\u751f\u6210\u4ea4\u6613\u660e\u7ec6\u6c47\u603b\u6570\u636eend... orgId :" + orgId, (Object)(" bizDate: " + bizDate));
    }

    private QFilter getExtendFilter() {
        PluginProxy pluginProxy = PluginProxy.create(ITransDetailGetDataInterface.class, (String)"kd.sdk.tmc.tda.extpoint.transdetail.ITransDetailGetDataInterface");
        List lists = pluginProxy.callReplace(p -> p.getExtendFilter());
        if (EmptyUtil.isNoEmpty((Object)lists) && lists.size() > 0 && EmptyUtil.isNoEmpty(lists.get(0))) {
            return (QFilter)lists.get(0);
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    private DynamicObject getExsitEntry(DynamicObject monthSummary, Row row, String area) {
        DynamicObjectCollection entrys = monthSummary.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            Long currencyId = entry.getLong("currency.id");
            if (!row.getLong("currency.id").equals(currencyId) || !entry.getString("area").equals(area)) continue;
            return entry;
        }
        return entrys.addNew();
    }

    private DynamicObject getMonthSummary(Long orgId, Date bizDate) {
        DynamicObject summary = TmcDataServiceHelper.newDynamicObject((String)"tda_transdetailsummary");
        summary.set("org", (Object)orgId);
        summary.set("monthdate", (Object)bizDate);
        summary.set("billno", (Object)(orgId + "-" + DateUtils.formatString((Date)bizDate, (String)"yyyyMM")));
        summary.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        summary.set("creator", (Object)RequestContext.get().getCurrUserId());
        summary.set("createtime", (Object)DateUtils.getCurrentTime());
        return summary;
    }

    private void deleteMonthSummary(Long orgId, Date bizDate) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter = filter.and(new QFilter("monthdate", "=", (Object)bizDate));
        DeleteServiceHelper.delete((String)"tda_transdetailsummary", (QFilter[])new QFilter[]{filter});
    }
}

