/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.detail.task;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.mservice.detail.TransDetailTaskSummaryService;

public class TransDetailScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TransDetailScheduleTask.class);
    private static final String GROUP_SEPARATOR = "__";
    private static final int PAGE_SIZE = 100000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object[] transDetailLogs;
        if (!this.isOpenSettle()) {
            logger.info("\u7ed3\u7b97\u7ba1\u7406\u53c2\u6570\u672a\u5f00\u542f\uff0c\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u6c47\u603b\u6570\u636e\u8c03\u5ea6\u4efb\u52a1\u5df2\u7ed3\u675f\u3002");
            return;
        }
        logger.info("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u6c47\u603b\u6570\u636e\u8c03\u5ea6\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c...");
        QFilter filter = new QFilter("isfinish", "=", (Object)false);
        int batchNum = 0;
        do {
            if (!EmptyUtil.isNoEmpty((Object[])(transDetailLogs = TmcDataServiceHelper.load((String)"tda_transdetaillog", (String)"id,org,bizdate", (QFilter[])new QFilter[]{filter}, null, (int)0, (int)100000)))) continue;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    Map<String, List<DynamicObject>> groupDetails = Arrays.stream(transDetailLogs).collect(Collectors.groupingBy(o -> {
                        Long orgId = EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("org")) ? 0L : o.getDynamicObject("org").getLong("id");
                        Date bizDate = o.getDate("bizdate");
                        Date firstDayOfMonth = DateUtils.getFirstDayOfMonth((Date)bizDate);
                        return orgId + GROUP_SEPARATOR + DateUtils.formatString((Date)firstDayOfMonth, (String)"yyyy-MM-dd");
                    }));
                    logger.info("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u6c47\u603b\u6570\u636e\uff0c\u6279\u6b21\u53f7batchNum\uff1a" + ++batchNum + " ,\u5f85\u751f\u6210\u6570\u91cf\uff1a" + transDetailLogs.length);
                    TransDetailTaskSummaryService summaryService = new TransDetailTaskSummaryService();
                    for (String key : groupDetails.keySet()) {
                        String[] keys = key.split(GROUP_SEPARATOR);
                        Long orgId = Long.valueOf(keys[0]);
                        String bizDateStr = keys[1];
                        if (!EmptyUtil.isNoEmpty((Long)orgId)) continue;
                        try {
                            summaryService.summary(orgId, DateUtils.stringToDate((String)bizDateStr, (String)"yyyy-MM-dd"));
                        }
                        catch (Exception e) {
                            logger.error("\u6c47\u603b\u6570\u636e\u62a5\u9519\uff0c\u7ec4\u7ec7id + " + orgId + "\u4e1a\u52a1\u65e5\u671f\uff1a" + bizDateStr + "\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
                            throw e;
                        }
                    }
                    this.deleteTransDetails((DynamicObject[])transDetailLogs);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        } while (!EmptyUtil.isEmpty((Object[])transDetailLogs) && transDetailLogs.length >= 100000);
        logger.info("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u6c47\u603b\u6570\u636e\u8c03\u5ea6\u4efb\u52a1\uff0c\u7ed3\u675f\u6267\u884c...");
    }

    private void deleteTransDetails(DynamicObject[] transDetailLogs) {
        List ids = Arrays.stream(transDetailLogs).map(o -> o.getLong("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"tda_transdetaillog"), (Object[])ids.toArray());
    }

    private boolean isOpenSettle() {
        return SysParamHelper.isOpenSettle();
    }
}

