/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.finance.task;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.BatchTaskStatusSynHelper;

public class FinanceCostScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(FinanceCostScheduleTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        Timestamp beginTime = DateUtils.getCurrentTime();
        String taskNum = "FinCost-" + DateUtils.formatString((Date)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet loanBills = QueryServiceHelper.queryDataSet((String)"FinanceCostScheduleTask.execute", (String)"cfm_loanbill", (String)"id,drawtype,cleardate,endinstdate,startintdate,case when renewalexpiredate is null then expiredate else renewalexpiredate end as expiredate", (QFilter[])new QFilter[]{filter}, null);
        DataSet runedClearLoanBill = QueryServiceHelper.queryDataSet((String)"FinanceCostScheduleTask.gettdabillinfo", (String)"tda_loanbillintinfo", (String)"loanbillid", (QFilter[])new QFilter[]{new QFilter("isclear", "=", (Object)Boolean.TRUE)}, null);
        HashSet<Long> clearLoanBill = new HashSet<Long>(16);
        for (Object row : runedClearLoanBill) {
            clearLoanBill.add(row.getLong("loanbillid"));
        }
        ArrayList loanBillList = new ArrayList(10);
        for (Row loanBill : loanBills) {
            boolean clearFlag = "closeout".equals(loanBill.getString("drawtype")) || loanBill.getDate("cleardate") != null;
            boolean dateEquals = loanBill.getDate("cleardate") != null && loanBill.getDate("endinstdate") != null && loanBill.getDate("cleardate").compareTo(DateUtils.getNextDay((Date)loanBill.getDate("endinstdate"), (int)1)) <= 0;
            boolean clearRuned = clearLoanBill.contains(loanBill.getLong("id"));
            if (clearFlag && (dateEquals || clearRuned)) continue;
            HashMap<String, Object> loanInfoMap = new HashMap<String, Object>(8);
            loanInfoMap.put("loanbillid", loanBill.getLong("id"));
            Date beginDate = loanBill.getDate("endinstdate") == null ? loanBill.getDate("startintdate") : DateUtils.getNextDay((Date)loanBill.getDate("endinstdate"), (int)1);
            loanInfoMap.put("begindate", beginDate);
            Date endDate = loanBill.getDate("cleardate") != null && loanBill.getDate("cleardate").compareTo(loanBill.getDate("expiredate")) <= 0 ? loanBill.getDate("cleardate") : loanBill.getDate("expiredate");
            loanInfoMap.put("enddate", endDate);
            loanInfoMap.put("clearflag", "closeout".equals(loanBill.getString("drawtype")) || loanBill.getDate("cleardate") != null);
            loanInfoMap.put("tasknum", taskNum);
            loanBillList.add(loanInfoMap);
        }
        logger.info("FinanceCostScheduleTask\u8c03\u5ea6\u4efb\u52a1\u63d0\u6b3e\u5355\u6570\u91cf\uff1a" + loanBillList.size());
        List batchList = Lists.partition(loanBillList, (int)100);
        logger.info("FinanceCostScheduleTask\u8c03\u5ea6\u4efb\u52a1\u5206\u6279\u6570\u91cf\uff1a" + batchList.size());
        for (List mapList : batchList) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "kd.tmc.tda.fincostchedule");){
                logger.info("------FinanceCostScheduleTask MQ Message Send------");
                pub.publish((Object)mapList);
            }
        }
        BatchTaskStatusSynHelper.initTaskStatus((String)taskNum, (Date)beginTime, (int)batchList.size());
    }
}

